ORCA/M Asm65816 2.1.0

0001 F043                       title 'Integer      Math         GS ROM 3.0' 
0002 F043              ********************************************************
0003 F043              *                                                      *
0004 F043              *                Integer Math                          *
0005 F043              *                                                      *
0006 F043              ********************************************************
0007 F043
0008 F043
0009 F043              ********************************************************
0010 F043              *                                                      *
0011 F043              *              Copyright (C) 1985-1989                 *
0012 F043              *              Apple Computer, Inc.                    *
0013 F043              *              All Rights Reserved                     *
0014 F043              *                                                      *
0015 F043              ********************************************************
0016 F043
0017 F043
0018 F043              **********************************************************************
0019 F043              *
0020 F043              * Change History
0021 F043              *
0022 F043              * 30 Mar 89	Steven Glass
0023 F043              *
0024 F043              * Fixed bug in Long2Dec
0025 F043              *
0026 F043              *
0027 F043              **********************************************************************
0028 F043
0029 F043
0030 F043                       include 'all.macros' 
0031 F043
0032 F043              ****************************************************************
0033 F043              *
0034 F043              * INTEGER MATH TOOLS MAIN CODE SEGMENT
0035 F043              *
0036 F043              ****************************************************************
0037 F043
0038 F043
0039 F043              IMVerNum equ   $0300                    ;Version 3.0
0040 F043
0041 F043
0042 F043
0043 F043
0044 F043              ****************************************************************
0045 F043              *
0046 F043              * DATA
0047 F043              *
0048 F043              ****************************************************************
0049 F043
0050 F043
0051 F043              BadParam equ   $0B01
0052 F043              BadChar  equ   $0B02
0053 F043              Overflow equ   $0B03
0054 F043              ShortStr equ   $0B04
0055 F043
0056 F043
0057 F043
0058 F043              ;-----------------------------------------------
0059 F043              ;
0060 F043              ;   Imported addresses
0061 F043              ;
0062 F043              ;-----------------------------------------------
0063 F043
0064 F043                       IMPORT EndCall10 
0065 F043                       IMPORT EndCall12 
0066 F043                       IMPORT EndCall4 
0067 F043                       IMPORT EndCall6 
0068 F043                       IMPORT EndCall8 
0069 F043                       IMPORT ErrOut10 
0070 F043                       IMPORT ErrOut12 
0071 F043                       IMPORT ErrOut4 
0072 F043                       IMPORT ErrOut6 
0073 F043                       IMPORT ErrOut8 
0074 F043                       IMPORT oEndCall0 
0075 F043                       IMPORT oEndCall2 
0076 F043                       IMPORT oErrOut0 
0077 F043
0078 F043              ;-----------------------------------------------
0079 F043              ;
0080 F043              ;   Forward addresses and entries
0081 F043              ;
0082 F043              ;-----------------------------------------------
0083 F043
0084 F043                       ENTRY Bin2Hex 
0085 F043                       ENTRY Dec2Bin 
0086 F043                       ENTRY Dec2Int 
0087 F043                       ENTRY Dec2Long 
0088 F043                       ENTRY Fix2Frac 
0089 F043                       ENTRY Fix2Long 
0090 F043                       ENTRY Fix2X 
0091 F043                       ENTRY FixATan2 
0092 F043                       ENTRY FixDiv 
0093 F043                       ENTRY FixMul 
0094 F043                       ENTRY FixRatio 
0095 F043                       ENTRY FixRound 
0096 F043                       ENTRY Frac2Fix 
0097 F043                       ENTRY Frac2X 
0098 F043                       ENTRY FracCos 
0099 F043                       ENTRY FracDiv 
0100 F043                       ENTRY FracMul 
0101 F043                       ENTRY FracSin 
0102 F043                       ENTRY FracSqrt 
0103 F043                       ENTRY Hex2Bin 
0104 F043                       ENTRY Hex2Int 
0105 F043                       ENTRY Hex2Long 
0106 F043                       ENTRY HexIt 
0107 F043                       ENTRY HiWord 
0108 F043                       ENTRY IMActive 
0109 F043                       ENTRY IMVersion 
0110 F043                       ENTRY Int2Dec 
0111 F043                       ENTRY Int2Hex 
0112 F043                       ENTRY LoWord 
0113 F043                       ENTRY Long2Dec 
0114 F043                       ENTRY Long2Fix 
0115 F043                       ENTRY Long2Hex 
0116 F043                       ENTRY LongDiv 
0117 F043                       ENTRY LongMul 
0118 F043                       ENTRY Multiply 
0119 F043                       ENTRY SDivide 
0120 F043                       ENTRY UDIV 
0121 F043                       ENTRY UDivide 
0122 F043                       ENTRY X2Fix 
0123 F043                       ENTRY X2Frac 
0124 F043
0125 F043              ****************************************************************
0126 F043              *
0127 F043              * CALL TABLE
0128 F043              *
0129 F043              ****************************************************************
0130 F043
0131 F043                       EXPORT IMCallTable 
0132 F043              IMCallTable PROC 
0133 F043 2B 00 00 00           DC L:(TheEnd-IMCallTable)/4
0134 F047 DE FB FE 00           DC L:oEndCall0-1               ;power up init
0135 F04B DE FB FE 00           DC L:oEndCall0-1               ;application startup
0136 F04F DE FB FE 00           DC L:oEndCall0-1               ;application shutdown
0137 F053 F4 F0 FE 00           DC L:IMVersion-1
0138 F057 DE FB FE 00           DC L:oEndCall0-1               ;reset
0139 F05B FC F0 FE 00           DC L:IMActive-1
0140 F05F DE FB FE 00           DC L:oEndCall0-1               ;reserved
0141 F063 DE FB FE 00           DC L:oEndCall0-1               ;reserved
0142 F067 04 F1 FE 00           DC L:Multiply-1
0143 F06B 34 F1 FE 00           DC L:SDivide-1
0144 F06F 22 F1 FE 00           DC L:UDivide-1
0145 F073 9C F1 FE 00           DC L:LongMul-1
0146 F077 CC F1 FE 00           DC L:LongDiv-1
0147 F07B 10 F2 FE 00           DC L:FixRatio-1
0148 F07F 8C F2 FE 00           DC L:FixMul-1
0149 F083 91 F2 FE 00           DC L:FracMul-1
0150 F087 82 F2 FE 00           DC L:FixDiv-1
0151 F08B 87 F2 FE 00           DC L:FracDiv-1
0152 F08F 05 F4 FE 00           DC L:FixRound-1
0153 F093 1B F4 FE 00           DC L:FracSqrt-1
0154 F097 CE F4 FE 00           DC L:FracCos-1
0155 F09B DA F4 FE 00           DC L:FracSin-1
0156 F09F F6 F5 FE 00           DC L:FixATan2-1
0157 F0A3 5F F7 FE 00           DC L:HiWord-1
0158 F0A7 66 F7 FE 00           DC L:LoWord-1
0159 F0AB 70 F7 FE 00           DC L:Long2Fix-1
0160 F0AF A2 F7 FE 00           DC L:Fix2Long-1
0161 F0B3 75 F7 FE 00           DC L:Fix2Frac-1
0162 F0B7 A7 F7 FE 00           DC L:Frac2Fix-1
0163 F0BB A5 F3 FE 00           DC L:Fix2X-1
0164 F0BF AA F3 FE 00           DC L:Frac2X-1
0165 F0C3 E1 F7 FE 00           DC L:X2Fix-1
0166 F0C7 E6 F7 FE 00           DC L:X2Frac-1
0167 F0CB 36 F8 FE 00           DC L:Int2Hex-1
0168 F0CF 53 F8 FE 00           DC L:Long2Hex-1
0169 F0D3 AE F8 FE 00           DC L:Hex2Int-1
0170 F0D7 D0 F8 FE 00           DC L:Hex2Long-1
0171 F0DB 67 F9 FE 00           DC L:Int2Dec-1
0172 F0DF E4 F9 FE 00           DC L:Long2Dec-1
0173 F0E3 74 FA FE 00           DC L:Dec2Int-1
0174 F0E7 B4 FA FE 00           DC L:Dec2Long-1
0175 F0EB 9B FB FE 00           DC L:HexIt-1
0176 F0EF              TheEnd                                  ; 
0177 F0EF                       ENDP 
0178 F0EF
0179 F0EF
0180 F0EF
0181 F0EF              ****************************************************************
0182 F0EF              *
0183 F0EF              * NotYet
0184 F0EF              *
0185 F0EF              ****************************************************************
0186 F0EF
0187 F0EF                       EXPORT NotYet 
0188 F0EF              NotYet   PROC 
0189 F0EF A2 FF FF              ldx   #$FFFF
0190 F0F2 4C E4 FB              jmp   oErrOut0
0191 F0F5                       ENDP 
0192 F0F5
0193 F0F5
0194 F0F5
0195 F0F5              ****************************************************************
0196 F0F5              *
0197 F0F5              * IMVersion
0198 F0F5              *
0199 F0F5              ****************************************************************
0200 F0F5
0201 F0F5                       EXPORT IMVersion 
0202 F0F5              IMVersion PROC 
0203 F0F5 A9 00 03              lda   #IMVerNum
0204 F0F8 83 07                 sta   7,s
0205 F0FA 4C DF FB              jmp   oEndCall0
0206 F0FD                       ENDP 
0207 F0FD
0208 F0FD
0209 F0FD
0210 F0FD              ****************************************************************
0211 F0FD              *
0212 F0FD              * IMActive
0213 F0FD              *
0214 F0FD              ****************************************************************
0215 F0FD
0216 F0FD                       EXPORT IMActive 
0217 F0FD              IMActive PROC 
0218 F0FD A9 FF FF              lda   #$FFFF
0219 F100 83 07                 sta   7,s
0220 F102 4C DF FB              jmp   oEndCall0
0221 F105                       ENDP 
0222 F105
0223 F105
0224 F105
0225 F105              ;                copy intmath/math
0226 F105              ****************************************************************
0227 F105              *
0228 F105              * Multiply
0229 F105              *
0230 F105              * Multiplies two values on the stack.
0231 F105              *
0232 F105              * Low word is the signed result of multiplication.
0233 F105              * Two words together is the unsigned 32 bit result.
0234 F105              *
0235 F105              * The stack looks like this on input:
0236 F105              *
0237 F105              *      Result        8-B
0238 F105              *      M1            6-7
0239 F105              *      M2            4-5
0240 F105              *      Return        1-3
0241 F105              *
0242 F105              * Change History:
0243 F105              *
0244 F105              * January 28, 1987	  Steven Glass
0245 F105              *
0246 F105              *      New algoithm using a-reg instead of direct page for
0247 F105              *      holding high word of result saves lots of cycles.
0248 F105              *      Thanks to Chris Jewell for the suggestion and Jim Merrit
0249 F105              *      for forewarding it.
0250 F105              *
0251 F105              * February 10, 1987   Steven Glass, Fern Bachman, Mike Askins
0252 F105              *
0253 F105              *      Chris's algorithmn did not work.  We made it work.
0254 F105              *
0255 F105              ****************************************************************
0256 F105                       EXPORT Multiply 
0257 F105              Multiply PROC 
0258 F105              DReg     equ   1                        ; 1
0259 F105              RTL1     equ   DReg+2                   ; 3
0260 F105              RTL2     equ   RTL1+3                   ; 6
0261 F105              M2       equ   RTL2+3                   ; 9
0262 F105              M1       equ   M2+2                     ; B
0263 F105              Result   equ   M1+2                     ; D
0264 F105
0265 F105
0266 F105 0B                    phd                            ; save direct
0267 F106 3B                    tsc                            ; make stack into zp
0268 F107 5B                    tcd   
0269 F108
0270 F108 A5 09                 lda   M2                       ; move second input into
0271 F10A 85 0D                 sta   Result                   ; result
0272 F10C
0273 F10C A9 00 00              lda   #0                       ; zero a-reg
0274 F10F
0275 F10F A0 11 00              ldy   #17                      ; start y (our counter and 17)
0276 F112 18                    clc   
0277 F113
0278 F113              Mult1                                   ; 
0279 F113 6A                    ror   a
0280 F114 66 0D                 ror   Result
0281 F116 90 03                 bcc   Mult2
0282 F118 18                    clc   
0283 F119 65 0B                 adc   M1
0284 F11B
0285 F11B              Mult2                                   ; 
0286 F11B 88                    dey   
0287 F11C D0 F5                 bne   Mult1
0288 F11E 85 0F                 sta   Result+2
0289 F120
0290 F120 4C 0E FC              jmp   EndCall4
0291 F123
0292 F123                       ENDP 
0293 F123
0294 F123
0295 F123
0296 F123              ****************************************************************
0297 F123              *
0298 F123              * UDivide
0299 F123              *
0300 F123              * Divides one 16 bit value by another and returns a dividend
0301 F123              * and remainder.
0302 F123              *
0303 F123              * Inputs and result are passed on the stack.
0304 F123              *
0305 F123              * The stack on entry is as follows:
0306 F123              *
0307 F123              *      Remainder    10-11
0308 F123              *      Quotient     8-9
0309 F123              *      Numerator    6-7
0310 F123              *      Denom        4-5
0311 F123              *      Return       1-3
0312 F123              *
0313 F123              * This routine sets up the stack, moves the pointer to x.
0314 F123              * sets the data bank register to 0 and calls UDIV
0315 F123              *
0316 F123              ****************************************************************
0317 F123                       EXPORT UDivide 
0318 F123              UDivide  PROC 
0319 F123 0B                    phd   
0320 F124 3B                    tsc   
0321 F125 5B                    tcd   
0322 F126 22 79 F1 FE           jsl   UDIV
0323 F12A B0 03                 bcs   UDivErr
0324 F12C 4C 0E FC              jmp   EndCall4
0325 F12F              UDivErr                                 ; 
0326 F12F A2 01 0B              ldx   #BadParam                ; input parm error
0327 F132 4C 11 FC              jmp   ErrOut4
0328 F135
0329 F135                       ENDP 
0330 F135
0331 F135
0332 F135
0333 F135              ****************************************************************
0334 F135              *
0335 F135              * SDivide
0336 F135              *
0337 F135              * Divides one 16 bit value by another and returns a dividend
0338 F135              * and remainder.
0339 F135              *
0340 F135              * Inputs and result are passed on the stack.
0341 F135              *
0342 F135              * The stack on entry is as follows:
0343 F135              *
0344 F135              *      Remainder    10-11
0345 F135              *      Quotient     8-9
0346 F135              *      Numerator    6-7
0347 F135              *      Denom        4-5
0348 F135              *      Return       1-3
0349 F135              *
0350 F135              * This routine sets up the stack, moves the pointer to x.
0351 F135              * sets the data bank register to 0 and calls UDIV
0352 F135              *
0353 F135              * Change History
0354 F135              *
0355 F135              * 9 Feb 87     Steven Glass
0356 F135              *
0357 F135              *       The error exit path now cleans up the stack.
0358 F135              *
0359 F135              ****************************************************************
0360 F135                       EXPORT SDivide 
0361 F135              SDivide  PROC 
0362 F135
0363 F135              OrigDirect equ   1
0364 F135              RTL1     equ   OrigDirect+2
0365 F135              RTL2     equ   RTL1+3
0366 F135              Denom    equ   RTL2+3
0367 F135              Numerator equ   Denom+2
0368 F135              Quotient equ   Numerator+2
0369 F135              Remainder equ   Quotient+2
0370 F135
0371 F135
0372 F135 0B                    phd   
0373 F136 3B                    tsc   
0374 F137 5B                    tcd   
0375 F138
0376 F138              *
0377 F138              * Figure out the signs of the results:  Remainder is always the
0378 F138              * same sign as the numerator.  Quotient sign is Num.Sign xor
0379 F138              * Denom.Sign
0380 F138              *
0381 F138 A5 0B                 lda   Numerator                ; Get num
0382 F13A 48                    pha                            ; put quot sign on stack
0383 F13B 45 09                 eor   Denom                    ; eor with denom
0384 F13D 48                    pha                            ; push on stack
0385 F13E              * Now need absolute	values of operands
0386 F13E A5 0B                 lda   Numerator
0387 F140 10 06                 bpl   NoChange1
0388 F142 49 FF FF              eor   #$FFFF
0389 F145 1A                    inc   a
0390 F146 85 0B                 sta   Numerator
0391 F148 A5 09        NoChange1 lda   Denom
0392 F14A 10 06                 bpl   NoChange2
0393 F14C 49 FF FF              eor   #$FFFF
0394 F14F 1A                    inc   a
0395 F150 85 09                 sta   Denom
0396 F152              NoChange2                               ; 
0397 F152 22 79 F1 FE           jsl   UDIV                     ; do the divide
0398 F156 B0 19                 bcs   ErrorExit
0399 F158 68                    pla                            ; get quot sign
0400 F159 10 08                 bpl   NoChange3
0401 F15B A5 0D                 lda   Quotient
0402 F15D 49 FF FF              eor   #$FFFF
0403 F160 1A                    inc   a
0404 F161 85 0D                 sta   Quotient
0405 F163 68           NoChange3 pla                           ; get remainder sign
0406 F164 10 08                 bpl   NoChange4
0407 F166 A5 0F                 lda   Remainder
0408 F168 49 FF FF              eor   #$FFFF
0409 F16B 1A                    inc   a
0410 F16C 85 0F                 sta   Remainder
0411 F16E              NoChange4                               ; 
0412 F16E 4C 0E FC              jmp   EndCall4
0413 F171              ErrorExit                               ; 
0414 F171 68                    pla                            ; fix stack (added 9 Feb 87 by SEG)
0415 F172 68                    pla   
0416 F173 A2 01 0B              ldx   #BadParam
0417 F176 4C 11 FC              jmp   ErrOut4
0418 F179
0419 F179                       ENDP 
0420 F179
0421 F179
0422 F179
0423 F179              ****************************************************************
0424 F179              *
0425 F179              * UDIV
0426 F179              *
0427 F179              * This is called by both UDivide and SDivide to do the actual
0428 F179              * dividing.  The XRegister points to variables in the current
0429 F179              * data bank (0).
0430 F179              *
0431 F179              ****************************************************************
0432 F179                       EXPORT UDIV 
0433 F179              UDIV     PROC 
0434 F179              OrigDirect equ   1
0435 F179              RTL1     equ   OrigDirect+2
0436 F179              RTL2     equ   RTL1+3
0437 F179              Denom    equ   RTL2+3
0438 F179              Numerator equ   Denom+2
0439 F179              Quotient equ   Numerator+2
0440 F179              Remainder equ   Quotient+2
0441 F179
0442 F179 64 0F                 stz   Quotient+2               ; Zero high result
0443 F17B A5 09                 lda   Denom                    ; Divide by zero ?
0444 F17D D0 02                 bne   GoOn                     ; Nope
0445 F17F 38                    sec                            ; divide by zero *
0446 F180 6B                    rtl   
0447 F181
0448 F181              GoOn                                    ; 
0449 F181 A5 0B                 lda   Numerator                ; move numerator into
0450 F183 85 0D                 sta   Quotient                 ; Result
0451 F185 A0 10 00              ldy   #16
0452 F188 38                    sec                            ; set this to start?
0453 F189 26 0D        DivLoop  rol   Quotient
0454 F18B 26 0F                 rol   Quotient+2
0455 F18D 38                    sec   
0456 F18E A5 0F                 lda   Quotient+2
0457 F190 E5 09                 sbc   Denom
0458 F192 90 02                 bcc   DecCt
0459 F194 85 0F                 sta   Quotient+2
0460 F196 88           DecCt    dey   
0461 F197 D0 F0                 bne   DivLoop
0462 F199 26 0D                 rol   Quotient                 ; Shift last carry through for Quot
0463 F19B 18                    clc   
0464 F19C 6B                    rtl   
0465 F19D
0466 F19D                       ENDP 
0467 F19D
0468 F19D
0469 F19D
0470 F19D              ****************************************************************
0471 F19D              *
0472 F19D              * LongMul
0473 F19D              *
0474 F19D              * Multiplies two values on the stack.
0475 F19D              * Is called with a JSL after pushing the values and result onto
0476 F19D              * the stack.
0477 F19D              *
0478 F19D              * Value returned is in place of inputs.
0479 F19D              * Low word is the signed result of multiplication.
0480 F19D              * Two words together is the unsigned 32 bit result.
0481 F19D              *
0482 F19D              * The stack looks like this:
0483 F19D              *
0484 F19D              *      Result  12-19
0485 F19D              *      M1      8-11
0486 F19D              *      M2      4-7
0487 F19D              *      Return  1-3
0488 F19D              *
0489 F19D              ****************************************************************
0490 F19D                       EXPORT LongMul 
0491 F19D              LongMul  PROC 
0492 F19D
0493 F19D              DReg     equ   1
0494 F19D              RTL1     equ   DReg+2
0495 F19D              RTL2     equ   RTL1+3
0496 F19D              M2       equ   RTL2+3
0497 F19D              M1       equ   M2+4
0498 F19D              LResult  equ   M1+4
0499 F19D
0500 F19D 0B                    phd   
0501 F19E 3B                    tsc   
0502 F19F 5B                    tcd   
0503 F1A0
0504 F1A0 64 15                 stz   LResult+4                ; zero the high words of
0505 F1A2 64 17                 stz   LResult+6                ; the result
0506 F1A4
0507 F1A4 A5 09                 lda   M2
0508 F1A6 85 11                 sta   LResult
0509 F1A8 A5 0B                 lda   M2+2
0510 F1AA 85 13                 sta   LResult+2
0511 F1AC
0512 F1AC A0 21 00              ldy   #33                      ; number of bits in multiplier + 1
0513 F1AF 18                    clc   
0514 F1B0 66 17        MulLp    ror   LResult+6
0515 F1B2 66 15                 ror   LResult+4
0516 F1B4 66 13                 ror   LResult+2
0517 F1B6 66 11                 ror   LResult
0518 F1B8 90 0D                 bcc   DecCnt
0519 F1BA 18                    clc   
0520 F1BB A5 0D                 lda   M1
0521 F1BD 65 15                 adc   LResult+4
0522 F1BF 85 15                 sta   LResult+4
0523 F1C1 A5 0F                 lda   M1+2
0524 F1C3 65 17                 adc   LResult+6
0525 F1C5 85 17                 sta   LResult+6
0526 F1C7 88           DecCnt   dey   
0527 F1C8 D0 E6                 bne   MulLp
0528 F1CA 4C 3A FC              jmp   EndCall8
0529 F1CD
0530 F1CD                       ENDP 
0531 F1CD
0532 F1CD
0533 F1CD
0534 F1CD              ****************************************************************
0535 F1CD              *
0536 F1CD              * LongDiv
0537 F1CD              *
0538 F1CD              * Stack Looks Like:
0539 F1CD              *
0540 F1CD              *    Remainder   16-19
0541 F1CD              *    Quotient    12-15
0542 F1CD              *    Numerator   8-11
0543 F1CD              *    Denom       4-7
0544 F1CD              *    Return      1-3
0545 F1CD              *
0546 F1CD              ****************************************************************
0547 F1CD                       EXPORT LongDiv 
0548 F1CD              LongDiv  PROC 
0549 F1CD
0550 F1CD              DReg     equ   1
0551 F1CD              RTL1     equ   DReg+2
0552 F1CD              RTL2     equ   RTL1+3
0553 F1CD              LDenom   equ   RTL2+3
0554 F1CD              LNum     equ   LDenom+4
0555 F1CD              LQuot    equ   LNum+4
0556 F1CD              LRem     equ   LQuot+4
0557 F1CD
0558 F1CD 0B                    phd                            ; save direct register
0559 F1CE 3B                    tsc                            ; get stack pointer
0560 F1CF 5B                    tcd                            ; set direct register
0561 F1D0 A5 0D                 lda   LNum                     ; move numerator into
0562 F1D2 85 11                 sta   LQuot                    ; Result
0563 F1D4 A5 0F                 lda   LNum+2
0564 F1D6 85 13                 sta   LQuot+2
0565 F1D8 64 15                 stz   LQuot+4                  ; zero high result
0566 F1DA 64 17                 stz   LQuot+6
0567 F1DC A5 09                 lda   LDenom
0568 F1DE 05 0B                 ora   LDenom+2
0569 F1E0 D0 03                 bne   GoOn0
0570 F1E2 38                    sec                            ; divide by zero *
0571 F1E3 80 26                 bra   Done0
0572 F1E5              GoOn0                                   ; 
0573 F1E5 A0 20 00              ldy   #32
0574 F1E8 38                    sec                            ; set this to start?
0575 F1E9 26 11        DivLp    rol   LQuot
0576 F1EB 26 13                 rol   LQuot+2
0577 F1ED 26 15                 rol   LQuot+4
0578 F1EF 26 17                 rol   LQuot+6
0579 F1F1 38                    sec   
0580 F1F2 A5 15                 lda   LQuot+4
0581 F1F4 E5 09                 sbc   LDenom
0582 F1F6 AA                    tax   
0583 F1F7 A5 17                 lda   LQuot+6
0584 F1F9 E5 0B                 sbc   LDenom+2
0585 F1FB 90 04                 bcc   DecrCnt
0586 F1FD 85 17                 sta   LQuot+6
0587 F1FF 86 15                 stx   LQuot+4
0588 F201 88           DecrCnt  dey   
0589 F202 D0 E5                 bne   DivLp
0590 F204 26 11                 rol   LQuot                    ; Shift carry through for Quot
0591 F206 26 13                 rol   LQuot+2
0592 F208 4C 3A FC              jmp   EndCall8
0593 F20B              Done0                                   ; 
0594 F20B A2 01 0B              ldx   #BadParam
0595 F20E 4C 3D FC              jmp   ErrOut8
0596 F211
0597 F211                       ENDP 
0598 F211
0599 F211              ****************************************************************
0600 F211              *
0601 F211              * FixRatio
0602 F211              *
0603 F211              * Takes two integers and returns a fixed
0604 F211              *
0605 F211              * The stack is as follows when the function is called:
0606 F211              *
0607 F211              *     Space for Result
0608 F211              *     Numerator
0609 F211              *     Denom
0610 F211              *
0611 F211              * The FixRatio consists of two words:
0612 F211              *     High Word = Numerator DIV Denom
0613 F211              *     Low word  = (Numerator MOD Denom) * 2^16 DIV Denom
0614 F211              *
0615 F211              *
0616 F211              * Change History
0617 F211              *
0618 F211              * August 7, 1986       Bug when result was negative fixed by
0619 F211              *                      Kenton Hanson.
0620 F211              *
0621 F211              *
0622 F211              ****************************************************************
0623 F211                       EXPORT FixRatio 
0624 F211              FixRatio PROC 
0625 F211              OrigDirect equ   1
0626 F211              RTL1     equ   OrigDirect+2
0627 F211              RTL2     equ   RTL1+3
0628 F211              Denom    equ   RTL2+3
0629 F211              Numerator equ   Denom+2
0630 F211              Result   equ   Numerator+2
0631 F211
0632 F211
0633 F211 0B                    phd                            ; save the direct register
0634 F212 3B                    tsc                            ; get stack pointer
0635 F213 5B                    tcd                            ; put it in direct register
0636 F214
0637 F214 A5 09                 lda   Denom                    ; check for div by zero
0638 F216 D0 07                 bne   GoOnx
0639 F218 A9 FF 7F              lda   #$7FFF
0640 F21B 85 0F                 sta   Result+2
0641 F21D 80 61                 bra   TheEnd
0642 F21F
0643 F21F 45 0B        GoOnx    eor   Numerator                ; determine sign of
0644 F221 48                    pha                            ; high bit is sign
0645 F222
0646 F222 F4 00 00              pea   0                        ; push space for result
0647 F225 F4 00 00              pea   0
0648 F228
0649 F228 A5 0B                 lda   Numerator
0650 F22A 10 04                 bpl   NumPos
0651 F22C 49 FF FF              eor   #$FFFF
0652 F22F 1A                    inc   a
0653 F230 48           NumPos   pha   
0654 F231 A5 09                 lda   Denom
0655 F233 10 04                 bpl   DenPos
0656 F235 49 FF FF              eor   #$FFFF
0657 F238 1A                    inc   a
0658 F239 48           DenPos   pha   
0659 F23A
0660 F23A A2 0B 0B 22           _UDivide 
0661 F241
0662 F241 68                    pla                            ; get result of unsigned divide
0663 F242 85 0F                 sta   Result+2                 ; to zero page
0664 F244 FA                    plx                            ; get remainder in x
0665 F245
0666 F245 F4 00 00              pea   0                        ; make room for result of
0667 F248 F4 00 00              pea   0                        ; long divide
0668 F24B F4 00 00              pea   0
0669 F24E F4 00 00              pea   0
0670 F251
0671 F251 DA                    phx                            ; put remainder * 2^16 on stack
0672 F252 F4 00 00              pea   0
0673 F255
0674 F255 F4 00 00              pea   0
0675 F258 A5 09                 lda   Denom
0676 F25A 10 04                 bpl   Pos2
0677 F25C 49 FF FF              eor   #$FFFF
0678 F25F 1A                    inc   a
0679 F260 48           Pos2     pha   
0680 F261
0681 F261 A2 0B 0D 22           _LongDivide 
0682 F268
0683 F268 68                    pla                            ; get low word of result
0684 F269 85 0D                 sta   Result                   ;
0685 F26B 68                    pla                            ; ignore high word
0686 F26C 68                    pla                            ; ignore remainder
0687 F26D 68                    pla   
0688 F26E 68                    pla                            ; get sign off stack
0689 F26F 10 0F                 bpl   TheEnd                   ; NoInversion
0690 F271 A9 00 00              lda   #0                       ;<klh, 17Jul86, was #1>
0691 F274 38                    sec   
0692 F275 E5 0D                 sbc   Result
0693 F277 85 0D                 sta   Result
0694 F279 A9 00 00              lda   #0
0695 F27C E5 0F                 sbc   Result+2
0696 F27E 85 0F                 sta   Result+2
0697 F280              TheEnd                                  ; 
0698 F280 4C 0E FC              jmp   EndCall4
0699 F283
0700 F283                       ENDP 
0701 F283              ;                copy intmath/math2
0702 F283              ****************************************************************
0703 F283              *
0704 F283              * FUNCTION FixMul (x, y: Fix): Fix;
0705 F283              * FUNCTION FracMul (x, y: Fract): Fract;
0706 F283              *
0707 F283              * Multiplies two values on the stack.
0708 F283              * Is called with a JSL after pushing the values and result onto
0709 F283              * the stack.
0710 F283              *
0711 F283              * FUNCTION FixDiv (x, y: Fix): Fix;
0712 F283              * FUNCTION FracxDiv (x, y: Fract): Fract;
0713 F283              *
0714 F283              * Same as FracMul, except returns x divided by y
0715 F283              *
0716 F283              * The stack looks like this on input:
0717 F283              *
0718 F283              *      Result        C-F
0719 F283              *      M1            8-B
0720 F283              *      M2            4-7
0721 F283              *      Return        1-3
0722 F283              *
0723 F283              ****************************************************************
0724 F283                       EXPORT FixDiv 
0725 F283              FixDiv   PROC 
0726 F283              DReg     equ   1
0727 F283              RTL1     equ   DReg+2
0728 F283              RTL2     equ   RTL1+3
0729 F283              M2       equ   RTL2+3
0730 F283              M1       equ   M2+4
0731 F283              Result   equ   M1+4
0732 F283
0733 F283 A0 10 00              ldy   #16
0734 F286 80 0D                 bra   FMulDiv
0735 F288
0736 F288                       EXPORT FracDiv 
0737 F288              FracDiv                                 ; 
0738 F288
0739 F288 A0 1E 00              ldy   #30
0740 F28B 80 08                 bra   FMulDiv
0741 F28D
0742 F28D                       EXPORT FixMul 
0743 F28D              FixMul                                  ; 
0744 F28D
0745 F28D A0 00 00              ldy   #0
0746 F290 80 03                 bra   FMulDiv
0747 F292
0748 F292                       EXPORT FracMul 
0749 F292              FracMul                                 ; 
0750 F292
0751 F292 A0 E1 FF              ldy   #-31
0752 F295
0753 F295 0B           FMulDiv  phd                            ; save direct reg
0754 F296 3B                    tsc                            ; set direct reg to
0755 F297 5B                    tcd                            ; point to place on stack
0756 F298 64 11                 stz   Result                   ; zero the Result
0757 F29A 64 13                 stz   Result+2
0758 F29C
0759 F29C A5 0F                 lda   M1+2
0760 F29E 45 0B                 eor   M2+2
0761 F2A0 48                    pha                            ; push eor of signs onto stack
0762 F2A1
0763 F2A1 A5 0F                 lda   M1+2
0764 F2A3 10 0F                 bpl   bplM1
0765 F2A5 A9 00 00              lda   #00
0766 F2A8 38                    sec   
0767 F2A9 E5 0D                 sbc   M1
0768 F2AB 85 0D                 sta   M1
0769 F2AD A9 00 00              lda   #00
0770 F2B0 E5 0F                 sbc   M1+2
0771 F2B2 85 0F                 sta   M1+2
0772 F2B4 A5 0B        bplM1    lda   M2+2
0773 F2B6 10 0F                 bpl   MDSwtch
0774 F2B8 A9 00 00              lda   #00
0775 F2BB 38                    sec   
0776 F2BC E5 09                 sbc   M2
0777 F2BE 85 09                 sta   M2
0778 F2C0 A9 00 00              lda   #00
0779 F2C3 E5 0B                 sbc   M2+2
0780 F2C5 85 0B                 sta   M2+2
0781 F2C7 98           MDSwtch  tya   
0782 F2C8 D0 33                 bne   NotFxMul
0783 F2CA
0784 F2CA A0 20 00              ldy   #32                      ; note a := 0
0785 F2CD 06 11        fxLoop   asl   Result
0786 F2CF 26 13                 rol   Result+2
0787 F2D1 2A                    rol   a
0788 F2D2 30 51                 bmi   fixOver
0789 F2D4 26 09                 rol   M2
0790 F2D6 26 0B                 rol   M2+2
0791 F2D8 90 14                 bcc   decIt
0792 F2DA AA                    tax                            ; save a
0793 F2DB 18                    clc   
0794 F2DC A5 0D                 lda   M1
0795 F2DE 65 11                 adc   Result
0796 F2E0 85 11                 sta   Result
0797 F2E2 A5 0F                 lda   M1+2
0798 F2E4 65 13                 adc   Result+2
0799 F2E6 85 13                 sta   Result+2
0800 F2E8 8A                    txa                            ; restore a
0801 F2E9 90 03                 bcc   decIt
0802 F2EB 1A                    inc   a
0803 F2EC 30 37                 bmi   fixOver
0804 F2EE 88           decIt    dey   
0805 F2EF D0 DC                 bne   fxLoop
0806 F2F1
0807 F2F1 06 11                 asl   Result                   ; sets carry for bcs below
0808 F2F3 A6 13                 ldx   Result+2
0809 F2F5 86 11                 stx   Result
0810 F2F7 85 13                 sta   Result+2
0811 F2F9 B0 3E                 bcs   Rnding                   ; round up
0812 F2FB 90 46                 bcc   ChkSign                  ; no rounding, check sign of output
0813 F2FD
0814 F2FD 10 59        NotFxMul bpl   GoDvd
0815 F2FF
0816 F2FF 46 13        MulLoop  lsr   Result+2
0817 F301 66 11                 ror   Result
0818 F303 66 0B                 ror   M2+2
0819 F305 66 09                 ror   M2
0820 F307 90 0D                 bcc   DecCount
0821 F309 18                    clc   
0822 F30A A5 0D        lastAdd  lda   M1
0823 F30C 65 11                 adc   Result
0824 F30E 85 11                 sta   Result
0825 F310 A5 0F                 lda   M1+2
0826 F312 65 13                 adc   Result+2
0827 F314 85 13                 sta   Result+2
0828 F316 C8           DecCount iny   
0829 F317 30 E6                 bmi   MulLoop
0830 F319 D0 1A                 bne   roundIt
0831 F31B 46 09                 lsr   M2
0832 F31D 90 16                 bcc   roundIt
0833 F31F 06 0D                 asl   M1                       ;align M1 for the final add
0834 F321 26 0F                 rol   M1+2
0835 F323 90 E5                 bcc   lastAdd
0836 F325 64 11        fixOver  stz   Result                   ;fix overflow
0837 F327 A9 00 80              lda   #$8000
0838 F32A 85 13                 sta   Result+2
0839 F32C 68                    pla                            ;get sign of result
0840 F32D 30 26                 bmi   finMul
0841 F32F C6 11                 dec   Result
0842 F331 C6 13                 dec   Result+2
0843 F333 80 20                 bra   finMul
0844 F335
0845 F335 24 0B        roundIt  bit   M2+2
0846 F337 10 06                 bpl   NoRnding
0847 F339 E6 11        Rnding   inc   Result
0848 F33B D0 02                 bne   NoRnding
0849 F33D E6 13                 inc   Result+2
0850 F33F 24 13        NoRnding bit   Result+2
0851 F341 30 E2                 bmi   fixOver
0852 F343 68           ChkSign  pla   
0853 F344 10 0F                 bpl   finMul
0854 F346 A9 00 00              lda   #00
0855 F349 38                    sec   
0856 F34A E5 11                 sbc   Result
0857 F34C 85 11                 sta   Result
0858 F34E A9 00 00              lda   #00
0859 F351 E5 13                 sbc   Result+2
0860 F353 85 13                 sta   Result+2
0861 F355              finMul                                  ; 
0862 F355 4C 3A FC              jmp   EndCall8
0863 F358
0864 F358 A5 0D        GoDvd    lda   M1
0865 F35A 85 11                 sta   Result
0866 F35C 64 0D                 stz   M1
0867 F35E A5 0F                 lda   M1+2
0868 F360 85 13                 sta   Result+2
0869 F362 64 0F                 stz   M1+2
0870 F364
0871 F364 5A                    phy                            ;save y
0872 F365 A0 20 00              ldy   #32
0873 F368 18                    clc   
0874 F369 26 11        DvLoop1  rol   Result
0875 F36B 26 13                 rol   Result+2
0876 F36D 26 0D                 rol   M1
0877 F36F 26 0F                 rol   M1+2
0878 F371 38                    sec   
0879 F372 A5 0D                 lda   M1
0880 F374 E5 09                 sbc   M2
0881 F376 AA                    tax   
0882 F377 A5 0F                 lda   M1+2
0883 F379 E5 0B                 sbc   M2+2
0884 F37B 90 04                 bcc   NoGo1
0885 F37D 85 0F                 sta   M1+2
0886 F37F 86 0D                 stx   M1
0887 F381 88           NoGo1    dey   
0888 F382 D0 E5                 bne   DvLoop1
0889 F384
0890 F384 7A                    ply                            ;restore y
0891 F385 26 11        DvLoop2  rol   Result
0892 F387 26 13                 rol   Result+2
0893 F389 30 9A                 bmi   fixOver                  ;result overflowed
0894 F38B 26 0D                 rol   M1
0895 F38D 26 0F                 rol   M1+2
0896 F38F 38                    sec   
0897 F390 A5 0D                 lda   M1
0898 F392 E5 09                 sbc   M2
0899 F394 AA                    tax   
0900 F395 A5 0F                 lda   M1+2
0901 F397 E5 0B                 sbc   M2+2
0902 F399 90 04                 bcc   NoGo2
0903 F39B 85 0F                 sta   M1+2
0904 F39D 86 0D                 stx   M1
0905 F39F 88           NoGo2    dey   
0906 F3A0 10 E3                 bpl   DvLoop2
0907 F3A2 B0 95                 bcs   Rnding                   ; round result
0908 F3A4 90 9D                 bcc   ChkSign                  ; no rounding
0909 F3A6
0910 F3A6                       ENDP 
0911 F3A6
0912 F3A6
0913 F3A6
0914 F3A6
0915 F3A6
0916 F3A6
0917 F3A6
0918 F3A6              ****************************************************************
0919 F3A6              *
0920 F3A6              * PROCEDURE Fix2X (f: Fixed; var x: Extended );
0921 F3A6              * PROCEDURE Frac2X (f: Fract; var x: Extended );
0922 F3A6              *
0923 F3A6              *    Note:  Assumes Extended numbers are normalized
0924 F3A6              *
0925 F3A6              * The stack looks like this on input:
0926 F3A6              *
0927 F3A6              *      Fixed or Frac 8-B
0928 F3A6              *      A2            4-7       ;address of an Extended
0929 F3A6              *      Return        1-3
0930 F3A6              *
0931 F3A6              ****************************************************************
0932 F3A6
0933 F3A6                       EXPORT Fix2X 
0934 F3A6              Fix2X    PROC 
0935 F3A6
0936 F3A6              DReg     equ   1
0937 F3A6              RTL1     equ   DReg+2
0938 F3A6              RTL2     equ   RTL1+3
0939 F3A6              A2       equ   RTL2+3
0940 F3A6              M1       equ   A2+4
0941 F3A6
0942 F3A6 A2 0E 40              ldx   #$400e                   ; threshold extended exponent for Fixed
0943 F3A9 80 03                 bra   F2X
0944 F3AB
0945 F3AB                       EXPORT Frac2X 
0946 F3AB              Frac2X                                  ; 
0947 F3AB
0948 F3AB A2 00 40              ldx   #$4000                   ; threshold extended exponent for Fract
0949 F3AE
0950 F3AE 0B           F2X      phd                            ; save direct reg
0951 F3AF 3B                    tsc                            ; set direct reg to
0952 F3B0 5B                    tcd                            ; point to place on stack
0953 F3B1
0954 F3B1 A9 00 00              lda   #0
0955 F3B4 A8                    tay   
0956 F3B5 97 09                 sta   [<A2],y
0957 F3B7 C8                    iny   
0958 F3B8 C8                    iny   
0959 F3B9 97 09                 sta   [<A2],y
0960 F3BB C8                    iny   
0961 F3BC C8                    iny   
0962 F3BD
0963 F3BD A5 0F                 lda   M1+2
0964 F3BF 48                    pha                            ; save sign
0965 F3C0 10 11                 bpl   ZeroChk
0966 F3C2 A9 00 00              lda   #00
0967 F3C5 38                    sec   
0968 F3C6 E5 0D                 sbc   M1
0969 F3C8 85 0D                 sta   M1
0970 F3CA A9 00 00              lda   #00
0971 F3CD E5 0F                 sbc   M1+2
0972 F3CF 85 0F                 sta   M1+2
0973 F3D1 80 18                 bra   Nrml
0974 F3D3
0975 F3D3 D0 16        ZeroChk  bne   Nrml
0976 F3D5 A5 0D                 lda   M1
0977 F3D7 D0 0D                 bne   NLoop                    ; begin normalization
0978 F3D9
0979 F3D9 97 09                 sta   [<A2],y
0980 F3DB C8                    iny   
0981 F3DC C8                    iny   
0982 F3DD 97 09                 sta   [<A2],y
0983 F3DF C8                    iny   
0984 F3E0 C8                    iny   
0985 F3E1 97 09                 sta   [<A2],y
0986 F3E3 68                    pla                            ; pull sign of stack
0987 F3E4 80 1D                 bra   FinF2X
0988 F3E6
0989 F3E6 CA           NLoop    dex                            ; decrement exponent
0990 F3E7 06 0D                 asl   M1
0991 F3E9 26 0F                 rol   M1+2
0992 F3EB 10 F9        Nrml     bpl   NLoop
0993 F3ED
0994 F3ED
0995 F3ED A5 0D                 lda   M1
0996 F3EF 97 09                 sta   [<A2],y                  ; set least signficant word of Fixed
0997 F3F1 C8                    iny   
0998 F3F2 C8                    iny   
0999 F3F3 A5 0F                 lda   M1+2
1000 F3F5 97 09                 sta   [<A2],y                  ; set most signficant word of Fixed
1001 F3F7 C8                    iny   
1002 F3F8 C8                    iny   
1003 F3F9 68                    pla                            ; get sign from stack
1004 F3FA 85 0F                 sta   M1+2
1005 F3FC 8A                    txa                            ; put exponent into a
1006 F3FD 0A                    asl   a
1007 F3FE 06 0F                 asl   M1+2                     ; get sign into carry
1008 F400 6A                    ror   a                        ; shift sign into a
1009 F401 97 09                 sta   [<A2],y                  ; set exponent and sign
1010 F403              finF2X                                  ; 
1011 F403 4C 3A FC              jmp   EndCall8
1012 F406
1013 F406
1014 F406                       ENDP 
1015 F406
1016 F406              ****************************************************************
1017 F406              *
1018 F406              * FUNCTION FixRound (f: fixed): integer;
1019 F406              *
1020 F406              * The stack looks like this on input:
1021 F406              *
1022 F406              *      Result        8-9
1023 F406              *      A1            4-7
1024 F406              *      Return        1-3
1025 F406              *
1026 F406              ****************************************************************
1027 F406                       EXPORT FixRound 
1028 F406              FixRound PROC 
1029 F406
1030 F406              DReg     equ   1
1031 F406              RTL1     equ   DReg+2
1032 F406              RTL2     equ   RTL1+3
1033 F406              A1       equ   RTL2+3
1034 F406              Result   equ   A1+4
1035 F406
1036 F406 0B                    phd                            ; save direct reg
1037 F407 3B                    tsc                            ; set direct reg to
1038 F408 5B                    tcd                            ; point to place on stack
1039 F409
1040 F409 A6 0B                 ldx   A1+2
1041 F40B 86 0D                 stx   Result
1042 F40D
1043 F40D A5 09                 lda   A1
1044 F40F 10 08                 bpl   FinFxRnd                 ; no rounding bit, done
1045 F411 E8                    inx   
1046 F412 E0 00 80              cpx   #$8000
1047 F415 F0 02                 beq   FinFxRnd                 ; overflow, do not round up
1048 F417 86 0D                 stx   Result
1049 F419
1050 F419              FinFxRnd                                ; 
1051 F419 4C 0E FC              jmp   EndCall4
1052 F41C
1053 F41C                       ENDP 
1054 F41C
1055 F41C              ****************************************************************
1056 F41C              *
1057 F41C              * FUNCTION FracSqrt (x: Fract): Fract;
1058 F41C              *
1059 F41C              * Square root of x.  In this case, the leading two bits of Fract are BOTH
1060 F41C              * taken to be integer, that is, the value is interpreted as unsigned.
1061 F41C              *
1062 F41C              * The stack looks like this on input:
1063 F41C              *
1064 F41C              *      Result        8-B
1065 F41C              *      M1            4-7
1066 F41C              *      Return        1-3
1067 F41C              *
1068 F41C              ****************************************************************
1069 F41C
1070 F41C                       EXPORT FracSqrt 
1071 F41C              FracSqrt PROC 
1072 F41C
1073 F41C              DReg     equ   1
1074 F41C              RTL1     equ   DReg+2
1075 F41C              RTL2     equ   RTL1+3
1076 F41C              M1       equ   RTL2+3
1077 F41C              Result   equ   M1+4
1078 F41C              mask     equ   Result
1079 F41C              mask2    equ   M1
1080 F41C
1081 F41C 0B                    phd                            ; save direct reg
1082 F41D 3B                    tsc                            ; set direct reg to
1083 F41E 5B                    tcd                            ; point to place on stack
1084 F41F
1085 F41F 64 0F                 stz   Result+2
1086 F421 38                    sec   
1087 F422 A5 0B                 lda   M1+2
1088 F424 E9 00 40              sbc   #$4000
1089 F427 90 07                 bcc   LtOne
1090 F429 85 0B                 sta   M1+2
1091 F42B A9 00 40              lda   #$4000
1092 F42E 85 0F                 sta   Result+2
1093 F430 A9 00 10     LtOne    lda   #$1000                   ; initialize mask
1094 F433 85 0D                 sta   mask
1095 F435 38           RootLoop sec   
1096 F436 A5 0B                 lda   M1+2
1097 F438 E5 0F                 sbc   Result+2
1098 F43A 90 0F                 bcc   NoGo
1099 F43C E5 0D                 sbc   mask
1100 F43E 90 0B                 bcc   NoGo
1101 F440 85 0B                 sta   M1+2                     ; subtract succeeded, save result
1102 F442 18                    clc   
1103 F443 A5 0F                 lda   Result+2
1104 F445 65 0D                 adc   mask                     ; update Result
1105 F447 65 0D                 adc   mask
1106 F449 85 0F                 sta   Result+2
1107 F44B 06 09        NoGo     asl   M1
1108 F44D 26 0B                 rol   M1+2
1109 F44F 46 0D                 lsr   mask
1110 F451 90 E2                 bcc   RootLoop
1111 F453
1112 F453 A5 09                 lda   M1
1113 F455 AA                    tax                            ; M1 will now be stored in x
1114 F456 64 09                 stz   mask2                    ; location of M1 now used for mask2
1115 F458 66 09                 ror   mask2
1116 F45A 38           SqrtLoop sec   
1117 F45B E5 0D                 sbc   Result
1118 F45D A8                    tay                            ; save low intermediate result
1119 F45E A5 0B                 lda   M1+2
1120 F460 E5 0F                 sbc   Result+2
1121 F462 90 1B                 bcc   NoGos                    ; does not divide
1122 F464 48                    pha                            ; store hi result temp on stack
1123 F465 98                    tya   
1124 F466 E5 09                 sbc   mask2                    ; subtract mask
1125 F468 A8                    tay   
1126 F469 68                    pla                            ; restore hi result from stack
1127 F46A E9 00 00              sbc   #$0000
1128 F46D 90 10                 bcc   NoGos                    ; subtraction caused negative value
1129 F46F 85 0B                 sta   M1+2                     ; subtract succeeded, save result
1130 F471 BB                    tyx                            ; sty M1, that is, x
1131 F472 18                    clc   
1132 F473 A5 0D                 lda   Result
1133 F475 65 09                 adc   mask2                    ; update Result
1134 F477 65 09                 adc   mask2
1135 F479 85 0D                 sta   Result
1136 F47B 90 02                 bcc   NoGos
1137 F47D E6 0F                 inc   Result+2
1138 F47F 8A           NoGos    txa   
1139 F480 0A                    asl   a
1140 F481 AA                    tax   
1141 F482 26 0B                 rol   M1+2
1142 F484 46 09                 lsr   mask2
1143 F486 90 D2                 bcc   SqrtLoop
1144 F488
1145 F488 38                    sec                            ; need two more bits
1146 F489 E5 0D                 sbc   Result
1147 F48B A8                    tay                            ; save low intermediate result
1148 F48C A5 0B                 lda   M1+2
1149 F48E E5 0F                 sbc   Result+2
1150 F490 90 18                 bcc   ToGos                    ; does not divide
1151 F492 48                    pha                            ; store hi result temp on stack
1152 F493 A5 09                 lda   mask2                    ; lda 0
1153 F495 E9 00 80              sbc   #$8000                   ; subtract mask
1154 F498 98                    tya   
1155 F499 E5 09                 sbc   mask2                    ; subtract 0
1156 F49B A8                    tay   
1157 F49C 68                    pla                            ; restore hi result from stack
1158 F49D E5 09                 sbc   mask2                    ; subtract 0
1159 F49F 90 09                 bcc   ToGos                    ; subtraction caused negative value
1160 F4A1 85 0B                 sta   M1+2                     ; subtract succeeded, save result
1161 F4A3 BB                    tyx                            ; sty M1, that is, x
1162 F4A4 E6 0D                 inc   Result
1163 F4A6 D0 02                 bne   ToGos
1164 F4A8 E6 0F                 inc   Result+2
1165 F4AA 8A           ToGos    txa   
1166 F4AB 2A                    rol   a                        ; Note carry is set iff subtraction
1167 F4AC 26 0B                 rol   M1+2                     ; was successful
1168 F4AE
1169 F4AE 38                    sec                            ; determine round bit
1170 F4AF E5 0D                 sbc   Result
1171 F4B1 A8                    tay                            ; save low intermediate result
1172 F4B2 A5 0B                 lda   M1+2
1173 F4B4 E5 0F                 sbc   Result+2
1174 F4B6 90 14                 bcc   EndSqrt                  ; does not divide
1175 F4B8 48                    pha                            ; store hi result temp on stack
1176 F4B9 A5 09                 lda   mask2
1177 F4BB E9 00 40              sbc   #$4000                   ; subtract last mask
1178 F4BE 98                    tya   
1179 F4BF E5 09                 sbc   mask2                    ; subtract 0
1180 F4C1 68                    pla                            ; restore hi result from stack
1181 F4C2 E5 09                 sbc   mask2                    ; subtract 0
1182 F4C4 90 06                 bcc   EndSqrt                  ; subtraction caused negative value
1183 F4C6 E6 0D                 inc   Result
1184 F4C8 D0 02                 bne   EndSqrt
1185 F4CA E6 0F                 inc   Result+2
1186 F4CC
1187 F4CC              EndSqrt                                 ; 
1188 F4CC 4C 0E FC              jmp   EndCall4
1189 F4CF
1190 F4CF                       ENDP 
1191 F4CF
1192 F4CF
1193 F4CF
1194 F4CF              ****************************************************************
1195 F4CF              *
1196 F4CF              * FUNCTION FracCos (x: Fixed): Fixed;
1197 F4CF              * FUNCTION FracSin (x: Fixed): Fixed;
1198 F4CF              *
1199 F4CF              * Returns the Cos or Sin of argument (radians)
1200 F4CF              *
1201 F4CF              * The stack looks like this on input:
1202 F4CF              *
1203 F4CF              *      Result        8-B
1204 F4CF              *      M1            4-7
1205 F4CF              *      Return        1-3
1206 F4CF              *
1207 F4CF              ****************************************************************
1208 F4CF                       EXPORT FracCos 
1209 F4CF              FracCos  PROC 
1210 F4CF              DReg     equ   1
1211 F4CF              RTL1     equ   DReg+2
1212 F4CF              RTL2     equ   RTL1+3
1213 F4CF              M1       equ   RTL2+3
1214 F4CF              Result   equ   M1+4
1215 F4CF
1216 F4CF 0B                    phd                            ; save direct reg
1217 F4D0 3B                    tsc                            ; set direct reg to
1218 F4D1 5B                    tcd                            ; point to place on stack
1219 F4D2
1220 F4D2 A2 02 00              ldx   #2
1221 F4D5 24 0B                 bit   M1+2
1222 F4D7 30 0F                 bmi   Negate
1223 F4D9 10 1C                 bpl   Reduce
1224 F4DB
1225 F4DB                       EXPORT FracSin 
1226 F4DB              FracSin                                 ; 
1227 F4DB 0B                    phd                            ; save direct reg
1228 F4DC 3B                    tsc                            ; set direct reg to
1229 F4DD 5B                    tcd                            ; point to place on stack
1230 F4DE
1231 F4DE A2 00 00              ldx   #0
1232 F4E1 24 0B                 bit   M1+2
1233 F4E3 10 12                 bpl   Reduce
1234 F4E5 A2 04 00              ldx   #4
1235 F4E8 38           Negate   sec   
1236 F4E9 A9 00 00              lda   #00
1237 F4EC E5 09                 sbc   M1
1238 F4EE 85 09                 sta   M1
1239 F4F0 A9 00 00              lda   #00
1240 F4F3 E5 0B                 sbc   M1+2
1241 F4F5 85 0B                 sta   M1+2
1242 F4F7
1243 F4F7 A0 10 00     Reduce   ldy   #$10                     ;16 bits of division necessary
1244 F4FA 38           RemLoop  sec   
1245 F4FB A5 0B                 lda   M1+2
1246 F4FD E9 88 64              sbc   #$6488                   ;PI/2 (when shifted 14 bits to right)
1247 F500 30 02                 bmi   tooLarge
1248 F502 85 0B                 sta   M1+2
1249 F504 26 09        tooLarge rol   M1                       ;shift in result
1250 F506 26 0B                 rol   M1+2
1251 F508 88                    dey   
1252 F509 D0 EF                 bne   RemLoop
1253 F50B
1254 F50B 18                    clc   
1255 F50C 8A                    txa   
1256 F50D 65 09                 adc   M1                       ; remainder + phase shift
1257 F50F 48                    pha                            ; save on stack
1258 F510 4A                    lsr   a
1259 F511 90 07                 bcc   at4
1260 F513 A9 10 C9              lda   #$c910                   ; M1 := PI/4 - M1
1261 F516 E5 0B                 sbc   M1+2
1262 F518 85 0B                 sta   M1+2
1263 F51A 64 09        at4      stz   M1
1264 F51C 46 0B                 lsr   M1+2                     ; Fixed to Frac
1265 F51E 66 09                 ror   M1
1266 F520 46 0B                 lsr   M1+2
1267 F522 66 09                 ror   M1
1268 F524 46 0B                 lsr   M1+2
1269 F526 66 09                 ror   M1
1270 F528
1271 F528 48                    pha                            ; push space for return result sqr(x/2)
1272 F529 48                    pha   
1273 F52A D4 0B                 pei   M1+2
1274 F52C D4 09                 pei   M1
1275 F52E D4 0B                 pei   M1+2
1276 F530 D4 09                 pei   M1
1277 F532 A2 0B 10 22           _FracMul 
1278 F539
1279 F539 7A                    ply                            ; x2 := (x/2)^2
1280 F53A 84 0D                 sty   Result
1281 F53C FA                    plx   
1282 F53D 86 0F                 stx   Result+2
1283 F53F
1284 F53F 68                    pla                            ; get phase shift
1285 F540 48                    pha   
1286 F541 1A                    inc   a
1287 F542 29 02 00              and   #$0002
1288 F545 D0 4B                 bne   Cos
1289 F547
1290 F547 48                    pha                            ; x2*sn2
1291 F548 48                    pha   
1292 F549 DA                    phx   
1293 F54A 5A                    phy   
1294 F54B F4 A2 10              pea   $10A2
1295 F54E F4 E5 08              pea   $08E5
1296 F551 A2 0B 10 22           _FracMul 
1297 F558
1298 F558 18                    clc                            ; sn1 + x2*sn2
1299 F559 68                    pla   
1300 F55A 69 4D 31              adc   #$314D
1301 F55D A8                    tay   
1302 F55E 68                    pla   
1303 F55F 69 B3 AA              adc   #$AAB3
1304 F562 48                    pha                            ; x2*(sn1 + x2*sn2)
1305 F563 48                    pha   
1306 F564 48                    pha   
1307 F565 5A                    phy   
1308 F566 D4 0F                 pei   Result+2
1309 F568 D4 0D                 pei   Result
1310 F56A A2 0B 10 22           _FracMul 
1311 F571
1312 F571 18                    clc                            ; sn0 + x2*(xn1 + x2*sn2)
1313 F572 68                    pla   
1314 F573 69 09 D6              adc   #$D609
1315 F576 A8                    tay   
1316 F577 68                    pla   
1317 F578 69 FF 7F              adc   #$7FFF
1318 F57B 48                    pha                            ; (x/2)*(sn0 + x2*(sn1 + x2*sn2))
1319 F57C 48                    pha   
1320 F57D 48                    pha   
1321 F57E 5A                    phy   
1322 F57F D4 0B                 pei   M1+2
1323 F581 D4 09                 pei   M1
1324 F583 A2 0B 10 22           _FracMul 
1325 F58A
1326 F58A 7A                    ply   
1327 F58B 84 0D                 sty   Result
1328 F58D FA                    plx   
1329 F58E 86 0F                 stx   Result+2
1330 F590
1331 F590 80 4D                 bra   ckSign
1332 F592
1333 F592 48           Cos      pha                            ; x2*cs3
1334 F593 48                    pha   
1335 F594 DA                    phx   
1336 F595 5A                    phy   
1337 F596 F4 6E FA              pea   $FA6E
1338 F599 F4 42 2A              pea   $2A42
1339 F59C A2 0B 10 22           _FracMul 
1340 F5A3
1341 F5A3 18                    clc                            ; cs2 + x2*cs3
1342 F5A4 68                    pla   
1343 F5A5 69 9A F2              adc   #$F29A
1344 F5A8 A8                    tay   
1345 F5A9 68                    pla   
1346 F5AA 69 A7 2A              adc   #$2AA7
1347 F5AD 48                    pha                            ; x2*(cs2 + x2*cs3)
1348 F5AE 48                    pha   
1349 F5AF 48                    pha   
1350 F5B0 5A                    phy   
1351 F5B1 D4 0F                 pei   Result+2
1352 F5B3 D4 0D                 pei   Result
1353 F5B5 A2 0B 10 22           _FracMul 
1354 F5BC
1355 F5BC 18                    clc                            ; cs1 + x2*(cs2 + x2*cs3)
1356 F5BD 68                    pla   
1357 F5BE 69 A7 11              adc   #$11A7
1358 F5C1 A8                    tay   
1359 F5C2 68                    pla   
1360 F5C3 69 00 80              adc   #$8000
1361 F5C6 48                    pha                            ; x2*(cs1 + x2*(cs2 + x2*cs3))
1362 F5C7 48                    pha   
1363 F5C8 48                    pha   
1364 F5C9 5A                    phy   
1365 F5CA D4 0F                 pei   Result+2
1366 F5CC D4 0D                 pei   Result
1367 F5CE A2 0B 10 22           _FracMul 
1368 F5D5
1369 F5D5 18                    clc                            ; 1.0 + x2*(cs1 + x2*(cs2 + x2*cs3))
1370 F5D6 68                    pla   
1371 F5D7 85 0D                 sta   Result
1372 F5D9 68                    pla   
1373 F5DA 69 00 40              adc   #$4000
1374 F5DD 85 0F                 sta   Result+2
1375 F5DF
1376 F5DF 68           ckSign   pla                            ; retrieve phase shift
1377 F5E0 29 04 00              and   #$0004
1378 F5E3 F0 0F                 beq   EndCsSn
1379 F5E5 38                    sec   
1380 F5E6 A9 00 00              lda   #$0000
1381 F5E9 E5 0D                 sbc   Result
1382 F5EB 85 0D                 sta   Result
1383 F5ED A9 00 00              lda   #$0000
1384 F5F0 E5 0F                 sbc   Result+2
1385 F5F2 85 0F                 sta   Result+2
1386 F5F4
1387 F5F4              EndCsSn                                 ; 
1388 F5F4 4C 0E FC              jmp   EndCall4
1389 F5F7
1390 F5F7                       ENDP 
1391 F5F7
1392 F5F7              ****************************************************************
1393 F5F7              *
1394 F5F7              * FUNCTION FixATan2 (x, y: Fract): Fixed;
1395 F5F7              *
1396 F5F7              * Returns the fixed angle (radians [-PI to PI]) to the point x, y.
1397 F5F7              *
1398 F5F7              * The stack looks like this on input:
1399 F5F7              *
1400 F5F7              *      Result        C-F
1401 F5F7              *      M1            8-B
1402 F5F7              *      M2            4-7
1403 F5F7              *      Return        1-3
1404 F5F7              *
1405 F5F7              ****************************************************************
1406 F5F7                       EXPORT FixAtan2 
1407 F5F7              FixAtan2 PROC 
1408 F5F7              DReg     equ   1
1409 F5F7              RTL1     equ   DReg+2
1410 F5F7              RTL2     equ   RTL1+3
1411 F5F7              M2       equ   RTL2+3
1412 F5F7              M1       equ   M2+4
1413 F5F7              Result   equ   M1+4
1414 F5F7
1415 F5F7 0B                    phd                            ; save direct reg
1416 F5F8 3B                    tsc                            ; set direct reg to
1417 F5F9 5B                    tcd                            ; point to place on stack
1418 F5FA 64 11                 stz   Result                   ; zero the Result
1419 F5FC
1420 F5FC A5 0B                 lda   M2+2                     ; get y
1421 F5FE 0A                    asl   a
1422 F5FF 66 11                 ror   Result
1423 F601 10 0F                 bpl   bplM2
1424 F603 A9 00 00              lda   #00                      ; y := |y|
1425 F606 38                    sec   
1426 F607 E5 09                 sbc   M2
1427 F609 85 09                 sta   M2
1428 F60B A9 00 00              lda   #00
1429 F60E E5 0B                 sbc   M2+2
1430 F610 85 0B                 sta   M2+2
1431 F612 A5 0F        bplM2    lda   M1+2                     ; get x
1432 F614 0A                    asl   a
1433 F615 66 11                 ror   Result
1434 F617 10 0F                 bpl   bplM1
1435 F619 A9 00 00              lda   #00                      ; x := |x|
1436 F61C 38                    sec   
1437 F61D E5 0D                 sbc   M1
1438 F61F 85 0D                 sta   M1
1439 F621 A9 00 00              lda   #00
1440 F624 E5 0F                 sbc   M1+2
1441 F626 85 0F                 sta   M1+2
1442 F628 38           bplM1    sec   
1443 F629 A5 0D                 lda   M1
1444 F62B E5 09                 sbc   M2
1445 F62D A5 0F                 lda   M1+2
1446 F62F E5 0B                 sbc   M2+2
1447 F631 66 11                 ror   Result                   ; carry is set iff |x| >= |y|
1448 F633 D4 11                 pei   Result                   ; save reduction information on stack
1449 F635
1450 F635 64 13                 stz   Result+2                 ; initialize result
1451 F637 A5 0F                 lda   M1+2                     ; check for zero argument
1452 F639 05 0D                 ora   M1
1453 F63B D0 05                 bne   ckM2
1454 F63D 64 11        ZeroNum  stz   Result
1455 F63F 82 E3 00              brl   NoRnd                    ; no polynomial evaluation
1456 F642 A5 0B        ckM2     lda   M2+2
1457 F644 05 09                 ora   M2
1458 F646 F0 F5                 beq   ZeroNum
1459 F648 48                    pha                            ; push space for return
1460 F649 48                    pha   
1461 F64A A5 11                 lda   Result
1462 F64C 30 0A                 bmi   YoverX                   ; argument reduction is y/x
1463 F64E
1464 F64E D4 0F                 pei   M1+2                     ; argument reduction is x/y
1465 F650 D4 0D                 pei   M1
1466 F652 D4 0B                 pei   M2+2
1467 F654 D4 09                 pei   M2
1468 F656 80 08                 bra   DivIt
1469 F658
1470 F658 D4 0B        YoverX   pei   M2+2
1471 F65A D4 09                 pei   M2
1472 F65C D4 0F                 pei   M1+2
1473 F65E D4 0D                 pei   M1
1474 F660
1475 F660 A2 0B 12 22  DivIt    _FracDiv 
1476 F667
1477 F667 7A                    ply   
1478 F668 84 09                 sty   M2                       ; store ratio in M2
1479 F66A FA                    plx   
1480 F66B 86 0B                 stx   M2+2
1481 F66D
1482 F66D 48                    pha   
1483 F66E 48                    pha   
1484 F66F DA                    phx   
1485 F670 5A                    phy   
1486 F671 DA                    phx   
1487 F672 5A                    phy   
1488 F673
1489 F673 A2 0B 10 22           _FracMul 
1490 F67A
1491 F67A 7A                    ply   
1492 F67B 84 0D                 sty   M1                       ; store x^2 in M1
1493 F67D FA                    plx   
1494 F67E 86 0F                 stx   M1+2
1495 F680
1496 F680 48                    pha   
1497 F681 48                    pha   
1498 F682 DA                    phx   
1499 F683 5A                    phy   
1500 F684 F4 3F FF              pea   $FF3F
1501 F687 F4 62 FE              pea   $FE62
1502 F68A A2 0B 10 22           _FracMul 
1503 F691
1504 F691 18                    clc   
1505 F692 68                    pla   
1506 F693 69 FE 92              adc   #$92FE
1507 F696 A8                    tay   
1508 F697 68                    pla   
1509 F698 69 5E 03              adc   #$035E
1510 F69B 48                    pha   
1511 F69C 48                    pha   
1512 F69D 48                    pha   
1513 F69E 5A                    phy   
1514 F69F D4 0F                 pei   M1+2
1515 F6A1 D4 0D                 pei   M1
1516 F6A3 A2 0B 10 22           _FracMul 
1517 F6AA
1518 F6AA 18                    clc   
1519 F6AB 68                    pla   
1520 F6AC 69 F2 77              adc   #$77F2
1521 F6AF A8                    tay   
1522 F6B0 68                    pla   
1523 F6B1 69 8C F8              adc   #$F88C
1524 F6B4 48                    pha   
1525 F6B5 48                    pha   
1526 F6B6 48                    pha   
1527 F6B7 5A                    phy   
1528 F6B8 D4 0F                 pei   M1+2
1529 F6BA D4 0D                 pei   M1
1530 F6BC A2 0B 10 22           _FracMul 
1531 F6C3
1532 F6C3 18                    clc   
1533 F6C4 68                    pla   
1534 F6C5 69 2C F7              adc   #$F72C
1535 F6C8 A8                    tay   
1536 F6C9 68                    pla   
1537 F6CA 69 62 0C              adc   #$0C62
1538 F6CD 48                    pha   
1539 F6CE 48                    pha   
1540 F6CF 48                    pha   
1541 F6D0 5A                    phy   
1542 F6D1 D4 0F                 pei   M1+2
1543 F6D3 D4 0D                 pei   M1
1544 F6D5 A2 0B 10 22           _FracMul 
1545 F6DC
1546 F6DC 18                    clc   
1547 F6DD 68                    pla   
1548 F6DE 69 BE 4E              adc   #$4EBE
1549 F6E1 A8                    tay   
1550 F6E2 68                    pla   
1551 F6E3 69 B6 EA              adc   #$EAB6
1552 F6E6 48                    pha   
1553 F6E7 48                    pha   
1554 F6E8 48                    pha   
1555 F6E9 5A                    phy   
1556 F6EA D4 0F                 pei   M1+2
1557 F6EC D4 0D                 pei   M1
1558 F6EE A2 0B 10 22           _FracMul 
1559 F6F5
1560 F6F5 18                    clc   
1561 F6F6 68                    pla   
1562 F6F7 69 73 A0              adc   #$A073
1563 F6FA A8                    tay   
1564 F6FB 68                    pla   
1565 F6FC 69 FF 3F              adc   #$3FFF
1566 F6FF 48                    pha   
1567 F700 48                    pha   
1568 F701 48                    pha   
1569 F702 5A                    phy   
1570 F703 D4 0B                 pei   M2+2
1571 F705 D4 09                 pei   M2
1572 F707 A2 0B 10 22           _FracMul 
1573 F70E
1574 F70E 68                    pla                            ; get result
1575 F70F 7A                    ply   
1576 F710 84 11                 sty   Result
1577 F712 0A                    asl   a                        ; Frac2Fix
1578 F713 26 11                 rol   Result
1579 F715 26 13                 rol   Result+2
1580 F717 0A                    asl   a
1581 F718 26 11                 rol   Result
1582 F71A 26 13                 rol   Result+2
1583 F71C 0A                    asl   a
1584 F71D 90 06                 bcc   noRnd                    ; check for rounding
1585 F71F E6 11                 inc   Result
1586 F721 D0 02                 bne   noRnd
1587 F723 E6 13                 inc   Result+2
1588 F725
1589 F725 68           noRnd    pla                            ; get reduction information from stack
1590 F726 0A                    asl   a
1591 F727 85 0D                 sta   M1
1592 F729 B0 0E                 bcs   at2                      ; |x| <= |y|
1593 F72B A9 20 92              lda   #$9220                   ; Result := PI/2 - Result
1594 F72E E5 11                 sbc   Result
1595 F730 85 11                 sta   Result
1596 F732 A9 01 00              lda   #$0001
1597 F735 E5 13                 sbc   Result+2
1598 F737 85 13                 sta   Result+2
1599 F739 06 0D        at2      asl   M1
1600 F73B 90 0E                 bcc   at1                      ; x was postive
1601 F73D A9 40 24              lda   #$2440                   ; Result := PI - Result
1602 F740 E5 11                 sbc   Result
1603 F742 85 11                 sta   Result
1604 F744 A9 03 00              lda   #$0003
1605 F747 E5 13                 sbc   Result+2
1606 F749 85 13                 sta   Result+2
1607 F74B 06 0D        at1      asl   M1
1608 F74D 90 0E                 bcc   EndATan2                 ; y was postive
1609 F74F A9 00 00              lda   #$0000
1610 F752 E5 11                 sbc   Result                   ; Result := -Result
1611 F754 85 11                 sta   Result
1612 F756 A9 00 00              lda   #$0000
1613 F759 E5 13                 sbc   Result+2
1614 F75B 85 13                 sta   Result+2
1615 F75D              EndAtan2                                ; 
1616 F75D 4C 3A FC              jmp   EndCall8
1617 F760
1618 F760
1619 F760              *        sn0     DC	     H'09 d6 ff 7f'
1620 F760              *                DC	     H'4d 31 b3 aa'
1621 F760              *                DC	     H'e5 08 a2 10'
1622 F760
1623 F760              *        cs0     DC	     H'00 00 00 40'
1624 F760              *                DC	     H'a7 11 00 80'
1625 F760              *                DC	     H'9a f2 a7 2a'
1626 F760              *                DC	     H'42 2a 6e fa'
1627 F760
1628 F760              *        at0     DC	     H'73 a0 ff 3f'
1629 F760              *                DC	     H'be 4e b6 ea'
1630 F760              *                DC	     H'2c f7 62 0c'
1631 F760              *                DC	     H'f2 77 8c f8'
1632 F760              *                DC	     H'fe 92 5e 03'
1633 F760              *                DC	     H'62 fe 3f ff'
1634 F760
1635 F760                       ENDP 
1636 F760
1637 F760
1638 F760
1639 F760
1640 F760
1641 F760
1642 F760
1643 F760              ****************************************************************
1644 F760              *
1645 F760              * FUNCTION HiWord (l: long): integer;
1646 F760              * FUNCTION LoWord (l: long): integer;
1647 F760              *
1648 F760              * The stack looks like this on input:
1649 F760              *
1650 F760              *      Result        8-9
1651 F760              *      A1            4-7
1652 F760              *      Return        1-3
1653 F760              *
1654 F760              ****************************************************************
1655 F760
1656 F760                       EXPORT HiWord 
1657 F760              HiWord   PROC 
1658 F760
1659 F760              DReg     equ   1
1660 F760              RTL1     equ   DReg+2
1661 F760              RTL2     equ   RTL1+3
1662 F760              A1       equ   RTL2+3
1663 F760              Result   equ   A1+4
1664 F760
1665 F760 0B                    phd                            ; save direct reg
1666 F761 3B                    tsc                            ; set direct reg to
1667 F762 5B                    tcd                            ; point to place on stack
1668 F763
1669 F763 A5 0B                 lda   A1+2
1670 F765 80 05                 bra   StuffInt
1671 F767
1672 F767                       EXPORT LoWord 
1673 F767              LoWord                                  ; 
1674 F767
1675 F767 0B                    phd                            ; save direct reg
1676 F768 3B                    tsc                            ; set direct reg to
1677 F769 5B                    tcd                            ; point to place on stack
1678 F76A
1679 F76A A5 09                 lda   A1
1680 F76C
1681 F76C 85 0D        StuffInt sta   Result
1682 F76E
1683 F76E
1684 F76E 4C 0E FC              jmp   EndCall4
1685 F771
1686 F771                       ENDP 
1687 F771
1688 F771              ****************************************************************
1689 F771              *
1690 F771              * FUNCTION Long2Fix (l: long): Fixed;
1691 F771              * FUNCTION Fix2Frac (f: Fixed): Fract;
1692 F771              *
1693 F771              * The stack looks like this on input:
1694 F771              *
1695 F771              *      Result        8-B
1696 F771              *      A1            4-7
1697 F771              *      Return        1-3
1698 F771              *
1699 F771              ****************************************************************
1700 F771
1701 F771                       EXPORT Long2Fix 
1702 F771              Long2Fix PROC 
1703 F771
1704 F771              DReg     equ   1
1705 F771              RTL1     equ   DReg+2
1706 F771              RTL2     equ   RTL1+3
1707 F771              A1       equ   RTL2+3
1708 F771              Result   equ   A1+4
1709 F771
1710 F771 A2 0F 00              ldx   #15
1711 F774 80 03                 bra   ShftLeft
1712 F776
1713 F776                       EXPORT Fix2Frac 
1714 F776              Fix2Frac                                ;       
1715 F776
1716 F776 A2 0D 00              ldx   #13
1717 F779
1718 F779 0B           ShftLeft phd                            ; save direct reg
1719 F77A 3B                    tsc                            ; set direct reg to
1720 F77B 5B                    tcd                            ; point to place on stack
1721 F77C
1722 F77C A5 09                 lda   A1
1723 F77E 85 0D                 sta   Result
1724 F780 A5 0B                 lda   A1+2
1725 F782 85 0F                 sta   Result+2
1726 F784 48                    pha                            ; save sign
1727 F785 10 11                 bpl   Xloop
1728 F787 A9 00 00              lda   #00
1729 F78A 38                    sec   
1730 F78B E5 0D                 sbc   Result
1731 F78D 85 0D                 sta   Result
1732 F78F A9 00 00              lda   #00
1733 F792 E5 0F                 sbc   Result+2
1734 F794 85 0F                 sta   Result+2
1735 F796 30 33                 bmi   MaxIt                    ; overflow occurred
1736 F798
1737 F798 06 0D        Xloop    asl   Result
1738 F79A 26 0F                 rol   Result+2
1739 F79C 30 2D                 bmi   MaxIt                    ; overflow has occurred
1740 F79E CA                    dex                            ; decrement counter
1741 F79F 10 F7                 bpl   Xloop
1742 F7A1 80 7F                 bra   ChkSign
1743 F7A3
1744 F7A3              ****************************************************************
1745 F7A3              *
1746 F7A3              * FUNCTION Fix2Long (f: Fixed): long;
1747 F7A3              * FUNCTION Frac2Fix (f: Fract): Fixed;
1748 F7A3              *
1749 F7A3              * The stack looks like this on input:
1750 F7A3              *
1751 F7A3              *      Result        8-B
1752 F7A3              *      A1            4-7
1753 F7A3              *      Return        1-3
1754 F7A3              *
1755 F7A3              ****************************************************************
1756 F7A3
1757 F7A3                       EXPORT Fix2long 
1758 F7A3              Fix2long                                ;       
1759 F7A3
1760 F7A3 A2 0F 00              ldx   #15
1761 F7A6 80 03                 bra   ShftRght
1762 F7A8
1763 F7A8                       EXPORT Frac2Fix 
1764 F7A8              Frac2Fix                                ;       
1765 F7A8
1766 F7A8 A2 0D 00              ldx   #13
1767 F7AB
1768 F7AB 0B           ShftRght phd                            ; save direct reg
1769 F7AC 3B                    tsc                            ; set direct reg to
1770 F7AD 5B                    tcd                            ; point to place on stack
1771 F7AE
1772 F7AE A5 09                 lda   A1
1773 F7B0 85 0D                 sta   Result
1774 F7B2 A5 0B                 lda   A1+2
1775 F7B4 85 0F                 sta   Result+2
1776 F7B6 48                    pha                            ; save sign
1777 F7B7 10 0F                 bpl   Rloop
1778 F7B9 A9 00 00              lda   #00
1779 F7BC 38                    sec   
1780 F7BD E5 0D                 sbc   Result
1781 F7BF 85 0D                 sta   Result
1782 F7C1 A9 00 00              lda   #00
1783 F7C4 E5 0F                 sbc   Result+2
1784 F7C6 85 0F                 sta   Result+2
1785 F7C8
1786 F7C8 8A           Rloop    txa   
1787 F7C9 80 44                 bra   Shftloop
1788 F7CB
1789 F7CB 64 0D        MaxIt    stz   Result                   ;fix overflow
1790 F7CD A9 00 80              lda   #$8000
1791 F7D0 85 0F                 sta   Result+2
1792 F7D2 68                    pla                            ;get sign of result
1793 F7D3 30 5F                 bmi   finX2F
1794 F7D5 C6 0D                 dec   Result
1795 F7D7 C6 0F                 dec   Result+2
1796 F7D9 80 59                 bra   finX2F
1797 F7DB
1798 F7DB 64 0D        ZeroIt   stz   Result
1799 F7DD 64 0F                 stz   Result+2
1800 F7DF 68                    pla                            ; take sign off stack
1801 F7E0 80 52                 bra   finX2F
1802 F7E2
1803 F7E2              ****************************************************************
1804 F7E2              *
1805 F7E2              * FUNCTION X2Fix (x: Extended ): Fixed;
1806 F7E2              * FUNCTION X2Frac(x: Extended ): Fract;
1807 F7E2              *
1808 F7E2              *    Note:  Assumes Extended numbers are normalized
1809 F7E2              *
1810 F7E2              * The stack looks like this on input:
1811 F7E2              *
1812 F7E2              *      Result        8-B
1813 F7E2              *      A1            4-7      ;address of an Extended
1814 F7E2              *      Return        1-3
1815 F7E2              *
1816 F7E2              ****************************************************************
1817 F7E2                       EXPORT X2Fix 
1818 F7E2              X2Fix                                   ; 
1819 F7E2
1820 F7E2 A2 0E 40              ldx   #$400e                   ; threshold extended exponent for Fixed
1821 F7E5 80 03                 bra   X2F
1822 F7E7
1823 F7E7                       EXPORT X2Frac 
1824 F7E7              X2Frac                                  ; 
1825 F7E7
1826 F7E7 A2 00 40              ldx   #$4000                   ; threshold extended exponent for Fract
1827 F7EA
1828 F7EA 0B           X2F      phd                            ; save direct reg
1829 F7EB 3B                    tsc                            ; set direct reg to
1830 F7EC 5B                    tcd                            ; point to place on stack
1831 F7ED
1832 F7ED A0 04 00              ldy   #4
1833 F7F0 B7 09                 lda   [<A1],y                  ; get least signficant word of Fixed
1834 F7F2 85 0D                 sta   Result
1835 F7F4 C8                    iny   
1836 F7F5 C8                    iny   
1837 F7F6 B7 09                 lda   [<A1],y                  ; get most signficant word of Fixed
1838 F7F8 85 0F                 sta   Result+2
1839 F7FA C8                    iny   
1840 F7FB C8                    iny   
1841 F7FC B7 09                 lda   [<A1],y                  ; get exponent and sign
1842 F7FE 48                    pha                            ; push sign onto stack
1843 F7FF 29 FF 7F              and   #$7fff                   ; strip sign
1844 F802 85 09                 sta   A1
1845 F804 8A                    txa   
1846 F805 18                    clc   
1847 F806 E5 09                 sbc   A1
1848 F808 30 C1                 bmi   MaxIt                    ; either a NaN, Inf or too large a value
1849 F80A C9 21 00              cmp   #33
1850 F80D 10 CC                 bpl   ZeroIt                   ; even MSB shifted too far to cause rnd
1851 F80F 46 0F        Shftloop lsr   Result+2
1852 F811 66 0D                 ror   Result
1853 F813 3A                    dec   a
1854 F814 10 F9                 bpl   Shftloop
1855 F816 90 06                 bcc   NoRnding
1856 F818
1857 F818 E6 0D        roundIt  inc   Result
1858 F81A D0 02                 bne   NoRnding
1859 F81C E6 0F                 inc   Result+2
1860 F81E 24 0F        NoRnding bit   Result+2
1861 F820 30 A9                 bmi   MaxIt
1862 F822 68           ChkSign  pla   
1863 F823 10 0F                 bpl   finX2F
1864 F825 A9 00 00              lda   #00
1865 F828 38                    sec   
1866 F829 E5 0D                 sbc   Result
1867 F82B 85 0D                 sta   Result
1868 F82D A9 00 00              lda   #00
1869 F830 E5 0F                 sbc   Result+2
1870 F832 85 0F                 sta   Result+2
1871 F834              finX2F                                  ; 
1872 F834 4C 0E FC              jmp   EndCall4
1873 F837
1874 F837                       ENDP 
1875 F837              ;                copy intmath/binhex
1876 F837
1877 F837
1878 F837
1879 F837              ****************************************************************
1880 F837              *
1881 F837              * Int2Hex
1882 F837              *
1883 F837              * Takes a 2-byte unsigned integer and produces an ASCII string
1884 F837              * representing the value in hexadecimal format.
1885 F837              *
1886 F837              ****************************************************************
1887 F837
1888 F837                       EXPORT Int2Hex 
1889 F837              Int2Hex  PROC 
1890 F837              TempVal  equ   1
1891 F837              BinVal   equ   19
1892 F837 0B                    phd   
1893 F838 F4 00 00              PushWord #0                    ;temp space
1894 F83B F4 00 00              PushWord #0 
1895 F83E 3B                    tsc   
1896 F83F 5B                    tcd   
1897 F840 A5 13                 lda   <BinVal                  ;move value into temp space
1898 F842 85 01                 sta   <TempVal
1899 F844 20 75 F8              jsr   Bin2Hex
1900 F847 68                    pla                            ;pull temp space
1901 F848 68                    pla   
1902 F849 E0 00 00              cpx   #0                       ;was there an error?
1903 F84C D0 03                 bne   RetErr                   ;yes
1904 F84E 4C 3A FC              jmp   EndCall8
1905 F851 4C 3D FC     RetErr   jmp   ErrOut8
1906 F854                       ENDP 
1907 F854
1908 F854
1909 F854              ****************************************************************
1910 F854              *
1911 F854              * Long2Hex
1912 F854              *
1913 F854              * Takes a 4-byte unsigned integer and produces an ASCII string
1914 F854              * representing the value in hexadecimal format.
1915 F854              *
1916 F854              ****************************************************************
1917 F854
1918 F854                       EXPORT Long2Hex 
1919 F854              Long2Hex PROC 
1920 F854              TempVal  equ   1
1921 F854              BinVal   equ   19
1922 F854 0B                    phd   
1923 F855 F4 00 00              PushWord #0                    ;temp space
1924 F858 F4 00 00              PushWord #0 
1925 F85B 3B                    tsc   
1926 F85C 5B                    tcd   
1927 F85D A5 13                 lda   <BinVal                  ;move value into the temp space
1928 F85F 85 01                 sta   <TempVal
1929 F861 A5 15                 lda   <BinVal+2
1930 F863 85 03                 sta   <TempVal+2
1931 F865 20 75 F8              jsr   Bin2Hex
1932 F868 68                    pla                            ;pull temp space
1933 F869 68                    pla   
1934 F86A E0 00 00              cpx   #0                       ;was there an error?
1935 F86D D0 03                 bne   RetErr                   ;yes
1936 F86F 4C 50 FC              jmp   EndCall10
1937 F872 4C 53 FC     RetErr   jmp   ErrOut10
1938 F875                       ENDP 
1939 F875
1940 F875
1941 F875              ****************************************************************
1942 F875              *
1943 F875              * Bin2Hex
1944 F875              *
1945 F875              ****************************************************************
1946 F875
1947 F875                       EXPORT Bin2Hex 
1948 F875              Bin2Hex  PROC 
1949 F875
1950 F875              TempVal  equ   1
1951 F875              Length   equ   13
1952 F875              StrPtr   equ   15
1953 F875
1954 F875 A4 0D                 ldy   <Length                  ;index into string
1955 F877 88           Loop     dey                            ;done with string?
1956 F878 30 1A                 bmi   Done                     ;yes
1957 F87A A5 01                 lda   <TempVal
1958 F87C 29 0F 00              and   #$F                      ;get lowest nibble of value
1959 F87F 20 A2 F8              jsr   MakeChar                 ;make into an ASCII char
1960 F882 E2 30                 sep   #$30                     ;8 bit mode
1961 F884 97 0F                 sta   [<StrPtr],y              ;put char in string
1962 F886 C2 30                 rep   #$30                     ;16 bit mode
1963 F888 A2 04 00              ldx   #4
1964 F88B 46 03        Shift    lsr   <TempVal+2               ;shift value to right by 4 bits
1965 F88D 66 01                 ror   <TempVal
1966 F88F CA                    dex   
1967 F890 D0 F9                 bne   Shift
1968 F892 80 E3                 bra   Loop
1969 F894
1970 F894 A5 01        Done     lda   <TempVal                 ;have we converted the whole value?
1971 F896 05 03                 ora   <TempVal+2
1972 F898 D0 04                 bne   StrErr                   ;no - so string was too short
1973 F89A A2 00 00              ldx   #0                       ;no error
1974 F89D 60                    rts   
1975 F89E
1976 F89E A2 04 0B     StrErr   ldx   #ShortStr
1977 F8A1 60                    rts   
1978 F8A2
1979 F8A2
1980 F8A2
1981 F8A2 C9 0A 00     MakeChar cmp   #$A
1982 F8A5 90 04                 bcc   Cont
1983 F8A7 18                    clc                            ;add 7 so when convert to ASCII the
1984 F8A8 69 07 00              adc   #7                       ;values 10-15 become A-F
1985 F8AB 69 30 00     Cont     adc   #$30                     ;convert value to an ASCII char
1986 F8AE 60                    rts   
1987 F8AF
1988 F8AF                       ENDP 
1989 F8AF              ;                copy intmath/hexbin
1990 F8AF
1991 F8AF
1992 F8AF
1993 F8AF              ****************************************************************
1994 F8AF              *
1995 F8AF              * Hex2Int
1996 F8AF              *
1997 F8AF              * Takes an ASCII string representing a hexadecimal value and
1998 F8AF              * produces a 2-byte unsigned integer.
1999 F8AF              *
2000 F8AF              ****************************************************************
2001 F8AF
2002 F8AF                       EXPORT Hex2Int 
2003 F8AF              Hex2Int  PROC 
2004 F8AF              BinVal   equ   21
2005 F8AF 0B                    phd   
2006 F8B0 F4 00 00              PushWord #0                    ;temp space
2007 F8B3 F4 00 00              PushWord #0 
2008 F8B6 F4 00 00              PushWord #0 
2009 F8B9 3B                    tsc   
2010 F8BA 5B                    tcd   
2011 F8BB 20 EF F8              jsr   Hex2Bin
2012 F8BE 68                    pla                            ;pull result
2013 F8BF 85 15                 sta   <BinVal
2014 F8C1 68                    pla                            ;overflow?
2015 F8C2 D0 06                 bne   OverErr                  ;yes
2016 F8C4 FA                    plx                            ;error flag
2017 F8C5 D0 07                 bne   RetErr
2018 F8C7 4C 24 FC              jmp   EndCall6
2019 F8CA
2020 F8CA A2 03 0B     OverErr  ldx   #Overflow
2021 F8CD 68                    pla                            ;error flag
2022 F8CE 4C 27 FC     RetErr   jmp   ErrOut6
2023 F8D1                       ENDP 
2024 F8D1
2025 F8D1
2026 F8D1              ****************************************************************
2027 F8D1              *
2028 F8D1              * Hex2Long
2029 F8D1              *
2030 F8D1              * Takes an ASCII string representing a hexadecimal value and
2031 F8D1              * produces a 4-byte unsigned integer.
2032 F8D1              *
2033 F8D1              ****************************************************************
2034 F8D1
2035 F8D1                       EXPORT Hex2Long 
2036 F8D1              Hex2Long PROC 
2037 F8D1              BinVal   equ   21
2038 F8D1 0B                    phd   
2039 F8D2 F4 00 00              PushWord #0                    ;temp space
2040 F8D5 F4 00 00              PushWord #0 
2041 F8D8 F4 00 00              PushWord #0 
2042 F8DB 3B                    tsc   
2043 F8DC 5B                    tcd   
2044 F8DD 20 EF F8              jsr   Hex2Bin
2045 F8E0 68                    pla                            ;pull result
2046 F8E1 85 15                 sta   <BinVal
2047 F8E3 68                    pla   
2048 F8E4 85 17                 sta   <BinVal+2
2049 F8E6 FA                    plx                            ;error flag
2050 F8E7 D0 03                 bne   RetErr
2051 F8E9 4C 24 FC              jmp   EndCall6
2052 F8EC
2053 F8EC 4C 27 FC     RetErr   jmp   ErrOut6
2054 F8EF                       ENDP 
2055 F8EF
2056 F8EF
2057 F8EF              ****************************************************************
2058 F8EF              *
2059 F8EF              * Hex2Bin
2060 F8EF              *
2061 F8EF              ****************************************************************
2062 F8EF
2063 F8EF                       EXPORT Hex2Bin 
2064 F8EF              Hex2Bin  PROC 
2065 F8EF
2066 F8EF              TempVal  equ   1
2067 F8EF              Digit    equ   5
2068 F8EF              Length   equ   15
2069 F8EF              StrPtr   equ   17
2070 F8EF
2071 F8EF A0 00 00              ldy   #0                       ;string index
2072 F8F2 A2 00 00              ldx   #0                       ;overflow flag
2073 F8F5 88                    dey   
2074 F8F6 C8           Blanks   iny   
2075 F8F7 C4 0F                 cpy   <Length                  ;end of string?
2076 F8F9 B0 41                 bcs   Return                   ;yes
2077 F8FB B7 11                 lda   [<StrPtr],y              ;skip leading blanks in string
2078 F8FD 29 7F 00              and   #$7F                     ;mask off hi byte and hi bit of lo byte
2079 F900 C9 20 00              cmp   #$20
2080 F903 F0 F1                 beq   Blanks
2081 F905
2082 F905 C4 0F        Loop     cpy   <Length                  ;end of string?
2083 F907 B0 2B                 bcs   Done                     ;yes
2084 F909 B7 11                 lda   [<StrPtr],y              ;get char from string
2085 F90B 29 7F 00              and   #$7F                     ;mask off hi byte and hi bit of lo byte
2086 F90E 20 3F F9              jsr   MakeBin                  ;convert to binary nibble
2087 F911 85 05                 sta   <Digit                   ;and save
2088 F913 A5 03                 lda   <TempVal+2
2089 F915 C9 00 10              cmp   #$1000                   ;will overflow occur?
2090 F918 90 01                 bcc   Cont                     ;no
2091 F91A E8                    inx                            ;yes - so flag it
2092 F91B 06 01        Cont     asl   <TempVal                 ;shift value over by 4 bits
2093 F91D 26 03                 rol   <TempVal+2
2094 F91F 06 01                 asl   <TempVal
2095 F921 26 03                 rol   <TempVal+2
2096 F923 06 01                 asl   <TempVal
2097 F925 26 03                 rol   <TempVal+2
2098 F927 06 01                 asl   <TempVal
2099 F929 26 03                 rol   <TempVal+2
2100 F92B A5 01                 lda   <TempVal
2101 F92D 05 05                 ora   <Digit                   ;add in digit
2102 F92F 85 01                 sta   <TempVal
2103 F931 C8                    iny   
2104 F932 80 D1                 bra   Loop
2105 F934
2106 F934 E0 00 00     Done     cpx   #0                       ;did overflow occur?
2107 F937 F0 03                 beq   Return                   ;no
2108 F939 A2 03 0B              ldx   #Overflow                ;yes - so set error number
2109 F93C 86 05        Return   stx   <Digit                   ;store error
2110 F93E 60                    rts   
2111 F93F
2112 F93F
2113 F93F
2114 F93F C9 3A 00     MakeBin  cmp   #$3A                     ;is char < ':' ?
2115 F942 90 16                 bcc   OK                       ;yes
2116 F944 C9 47 00              cmp   #$47                     ;is char < 'G' ?
2117 F947 90 09                 bcc   UC                       ;yes
2118 F949 C9 67 00              cmp   #$67                     ;is char > 'f' ?
2119 F94C B0 13                 bcs   CharErr                  ;yes
2120 F94E 38                    sec   
2121 F94F E9 20 00              sbc   #$20                     ;convert to upper case
2122 F952 C9 41 00     UC       cmp   #$41                     ;is char < 'A' ?
2123 F955 90 0A                 bcc   CharErr                  ;yes
2124 F957 E9 07 00              sbc   #7                       ;char is in 'A' - 'F'
2125 F95A 38           OK       sec   
2126 F95B E9 30 00              sbc   #$30                     ;convert char to binary value
2127 F95E 90 01                 bcc   CharErr                  ;char was < '0'
2128 F960 60                    rts   
2129 F961
2130 F961 68           CharErr  pla                            ;pull return address off stack
2131 F962 A2 02 0B              ldx   #BadChar
2132 F965 4C 3C F9              jmp   Return
2133 F968
2134 F968                       ENDP 
2135 F968              ;                copy intmath/bindec
2136 F968
2137 F968
2138 F968
2139 F968              ****************************************************************
2140 F968              *
2141 F968              * Int2Dec
2142 F968              *
2143 F968              * Takes a 2-byte integer (signed or unsigned) and produces an
2144 F968              * ASCII string representing the value in decimal format.
2145 F968              *
2146 F968              ****************************************************************
2147 F968
2148 F968                       EXPORT Int2Dec 
2149 F968              Int2Dec  PROC 
2150 F968
2151 F968              TempVal  equ   1
2152 F968              Digit    equ   5
2153 F968              Signed   equ   15
2154 F968              Length   equ   17
2155 F968              StrPtr   equ   19
2156 F968              BinVal   equ   23
2157 F968
2158 F968 0B                    phd   
2159 F969 F4 00 00              PushWord #0                    ;temp space
2160 F96C F4 00 00              PushWord #0 
2161 F96F F4 00 00              PushWord #0 
2162 F972 3B                    tsc   
2163 F973 5B                    tcd   
2164 F974
2165 F974 A4 11                 ldy   <Length                  ;index into string
2166 F976 A5 17                 lda   <BinVal                  ;move value into temp space
2167 F978 85 01                 sta   <TempVal
2168 F97A 10 0C                 bpl   Loop                     ;branch if value is positive
2169 F97C A5 0F                 lda   <Signed                  ;is value signed?
2170 F97E F0 08                 beq   Loop                     ;no - so skip next part
2171 F980 38                    sec   
2172 F981 A9 00 00              lda   #0                       ;value is negative so change it to
2173 F984 E5 01                 sbc   <TempVal                 ;positive
2174 F986 85 01                 sta   <TempVal
2175 F988
2176 F988 88           Loop     dey   
2177 F989 30 51                 bmi   StrErr                   ;done with string
2178 F98B              ;                                       ;TempVal := TempVal DIV 10
2179 F98B              ;                                       ;Digit   := TempVal MOD 10
2180 F98B 64 05                 stz   <Digit
2181 F98D A2 10 00              ldx   #16                      ;size of data in bits
2182 F990 18                    clc   
2183 F991 26 01        DivLoop  rol   <TempVal                 ;shift carry into dividend bit 0 which
2184 F993 26 05                 rol   <Digit                   ;will be the quotient and shift dividend
2185 F995 38                    sec                            ;at the same time
2186 F996 A5 05                 lda   <Digit
2187 F998 E9 0A 00              sbc   #10                      ;A := dividend - divisor
2188 F99B 90 02                 bcc   DecCnt                   ;branch if dividend < divisor
2189 F99D 85 05                 sta   <Digit                   ;dividend := dividend - divisor
2190 F99F CA           DecCnt   dex   
2191 F9A0 D0 EF                 bne   DivLoop
2192 F9A2 26 01                 rol   <TempVal                 ;shift in the last carry for the quotient
2193 F9A4
2194 F9A4 A5 05                 lda   <Digit                   ;convert digit into ASCII char
2195 F9A6 18                    clc   
2196 F9A7 69 30 00              adc   #$30
2197 F9AA E2 30                 sep   #$30                     ;8 bit mode
2198 F9AC 97 13                 sta   [<StrPtr],y              ;put char in string
2199 F9AE C2 30                 rep   #$30                     ;16 bit mode
2200 F9B0 A5 01                 lda   <TempVal                 ;is value 0?
2201 F9B2 D0 D4                 bne   Loop                     ;no - so continue
2202 F9B4
2203 F9B4 A5 0F                 lda   <Signed                  ;is value signed?
2204 F9B6 F0 10                 beq   Cont                     ;no
2205 F9B8 A5 17                 lda   <BinVal                  ;was original value negative?
2206 F9BA 10 0C                 bpl   Cont                     ;no
2207 F9BC 88                    dey                            ;room for '-' in front of string?
2208 F9BD 30 1D                 bmi   StrErr                   ;no
2209 F9BF A9 2D 00              lda   #$2D                     ;put '-' in front of string
2210 F9C2 E2 30                 sep   #$30                     ;8 bit mode
2211 F9C4 97 13                 sta   [<StrPtr],y
2212 F9C6 C2 30                 rep   #$30                     ;16 bit mode
2213 F9C8 88           Cont     dey                            ;is string filled?
2214 F9C9 30 0B                 bmi   Done                     ;yes
2215 F9CB
2216 F9CB                       longa off
2217 F9CB                       longi off
2218 F9CB E2 30                 sep   #$30                     ;8 bit mode
2219 F9CD A9 20        Fill     lda   #$20                     ;fill beginning of string with blanks
2220 F9CF 97 13                 sta   [<StrPtr],y
2221 F9D1 88                    dey   
2222 F9D2 10 F9                 bpl   Fill
2223 F9D4 C2 30                 rep   #$30                     ;16 bit mode
2224 F9D6                       longa on
2225 F9D6                       longi on
2226 F9D6
2227 F9D6 68           Done     pla                            ;temp space
2228 F9D7 68                    pla   
2229 F9D8 68                    pla   
2230 F9D9 4C 50 FC              jmp   EndCall10
2231 F9DC
2232 F9DC A2 04 0B     StrErr   ldx   #ShortStr
2233 F9DF 68                    pla                            ;temp space
2234 F9E0 68                    pla   
2235 F9E1 68                    pla   
2236 F9E2 4C 53 FC              jmp   ErrOut10
2237 F9E5
2238 F9E5                       ENDP 
2239 F9E5
2240 F9E5
2241 F9E5              ****************************************************************
2242 F9E5              *
2243 F9E5              * Long2Dec
2244 F9E5              *
2245 F9E5              * Takes a 4-byte integer (signed or unsigned) and produces an
2246 F9E5              * ASCII string representing the value in decimal format.
2247 F9E5              *
2248 F9E5              * Change History
2249 F9E5              *
2250 F9E5              * 30 Mar 89	Steven Glass
2251 F9E5              *
2252 F9E5              * Long2Dec stoped converting as soon as all the bits in the 
2253 F9E5              * low 3 bytes were zero.  This was reported on 37 Mar 89 by 
2254 F9E5              * Dave Tribby (an outside developer using UseNet).
2255 F9E5              * 
2256 F9E5              * Dave debugged the code for us using NiftyList and found 
2257 F9E5              * a lda Val, ora Val+1 that should have been ora Val+2.  
2258 F9E5              * Thanks Dave.
2259 F9E5              *
2260 F9E5              ****************************************************************
2261 F9E5
2262 F9E5                       EXPORT Long2Dec 
2263 F9E5              Long2Dec PROC 
2264 F9E5
2265 F9E5              TempVal  equ   1
2266 F9E5              Digit    equ   5
2267 F9E5              Signed   equ   15
2268 F9E5              Length   equ   17
2269 F9E5              StrPtr   equ   19
2270 F9E5              BinVal   equ   23
2271 F9E5
2272 F9E5 0B                    phd   
2273 F9E6 F4 00 00              PushWord #0                    ;temp space
2274 F9E9 F4 00 00              PushWord #0 
2275 F9EC F4 00 00              PushWord #0 
2276 F9EF 3B                    tsc   
2277 F9F0 5B                    tcd   
2278 F9F1
2279 F9F1 A4 11                 ldy   <Length                  ;index into string
2280 F9F3 A5 17                 lda   <BinVal                  ;copy value into temp space
2281 F9F5 85 01                 sta   <TempVal
2282 F9F7 A5 19                 lda   <BinVal+2
2283 F9F9 85 03                 sta   <TempVal+2
2284 F9FB 10 13                 bpl   Loop                     ;branch if value is positive
2285 F9FD A5 0F                 lda   <Signed                  ;is value signed?
2286 F9FF F0 0F                 beq   Loop                     ;no - so skip next part
2287 FA01 38                    sec   
2288 FA02 A9 00 00              lda   #0                       ;convert value to positive
2289 FA05 E5 01                 sbc   <TempVal
2290 FA07 85 01                 sta   <TempVal
2291 FA09 A9 00 00              lda   #0
2292 FA0C E5 03                 sbc   <TempVal+2
2293 FA0E 85 03                 sta   <TempVal+2
2294 FA10
2295 FA10 88           Loop     dey   
2296 FA11 30 58                 bmi   StrErr                   ;done with string
2297 FA13              ;                                       ;TempVal := TempVal DIV 10
2298 FA13              ;                                       ;Digit   := TempVal MOD 10
2299 FA13 64 05                 stz   <Digit
2300 FA15 A2 20 00              ldx   #32                      ;size of data in bits
2301 FA18 18                    clc   
2302 FA19 26 01        DivLoop  rol   <TempVal                 ;shift the carry into dividend bit 0
2303 FA1B 26 03                 rol   <TempVal+2               ;which will be the quotient and
2304 FA1D 26 05                 rol   <Digit                   ;shift the dividend at the same time
2305 FA1F 38                    sec   
2306 FA20 A5 05                 lda   <Digit                   ;A := dividend - divisor
2307 FA22 E9 0A 00              sbc   #10
2308 FA25 90 02                 bcc   DecCnt                   ;branch if dividend < divisor
2309 FA27 85 05                 sta   <Digit                   ;dividend := dividend - divisor
2310 FA29 CA           DecCnt   dex   
2311 FA2A D0 ED                 bne   DivLoop
2312 FA2C 26 01                 rol   <TempVal                 ;shift in the last carry for the quotient
2313 FA2E 26 03                 rol   <TempVal+2
2314 FA30
2315 FA30 A5 05                 lda   <Digit                   ;convert digit to ASCII char
2316 FA32 18                    clc   
2317 FA33 69 30 00              adc   #$30
2318 FA36 E2 30                 sep   #$30                     ;8 bit mode
2319 FA38 97 13                 sta   [<StrPtr],y
2320 FA3A C2 30                 rep   #$30                     ;16 bit mode
2321 FA3C A5 01                 lda   <TempVal
2322 FA3E 05 03                 ora   <TempVal+2               ;is value 0? ##### changed to +2, 30 Mar 89 SEG
2323 FA40 D0 CE                 bne   Loop                     ;no - so continue
2324 FA42
2325 FA42 A5 0F                 lda   <Signed                  ;is value signed?
2326 FA44 F0 10                 beq   Cont                     ;no
2327 FA46 A5 19                 lda   <BinVal+2                ;was original value negative?
2328 FA48 10 0C                 bpl   Cont                     ;no
2329 FA4A 88                    dey                            ;room for '-' in front of string?
2330 FA4B 30 1E                 bmi   StrErr                   ;no
2331 FA4D A9 2D 00              lda   #$2D                     ;put '-' in front of string
2332 FA50 E2 30                 sep   #$30                     ;8 bit mode
2333 FA52 97 13                 sta   [<StrPtr],y
2334 FA54 C2 30                 rep   #$30                     ;16 bit mode
2335 FA56 88           Cont     dey                            ;is string filled?
2336 FA57 30 0B                 bmi   Done                     ;yes
2337 FA59
2338 FA59                       longa off
2339 FA59                       longi off
2340 FA59 E2 30                 sep   #$30                     ;8 bit mode
2341 FA5B A9 20        Fill     lda   #$20                     ;fill beginning of string with blanks
2342 FA5D 97 13                 sta   [<StrPtr],y
2343 FA5F 88                    dey   
2344 FA60 10 F9                 bpl   Fill
2345 FA62 C2 30                 rep   #$30                     ;16 bit mode
2346 FA64                       longa on
2347 FA64                       longi on
2348 FA64
2349 FA64 68           Done     pla                            ;temp space
2350 FA65 68                    pla   
2351 FA66 68                    pla   
2352 FA67 5C 66 FC FE           jml   EndCall12
2353 FA6B
2354 FA6B A2 04 0B     StrErr   ldx   #ShortStr
2355 FA6E 68                    pla                            ;temp space
2356 FA6F 68                    pla   
2357 FA70 68                    pla   
2358 FA71 5C 69 FC FE           jml   ErrOut12
2359 FA75
2360 FA75                       ENDP 
2361 FA75
2362 FA75
2363 FA75
2364 FA75              ****************************************************************
2365 FA75              *
2366 FA75              * Dec2Int
2367 FA75              *
2368 FA75              * Takes an ASCII string representing a decimal value and
2369 FA75              * produces a 2-byte signed or unsigned integer.
2370 FA75              *
2371 FA75              ****************************************************************
2372 FA75
2373 FA75                       EXPORT Dec2Int 
2374 FA75              Dec2Int  PROC 
2375 FA75
2376 FA75              Signed   equ   15
2377 FA75              BinVal   equ   23
2378 FA75
2379 FA75 0B                    phd   
2380 FA76 F4 00 00              PushWord #0                    ;temp space
2381 FA79 F4 00 00              PushWord #0 
2382 FA7C F4 00 00              PushWord #0 
2383 FA7F 3B                    tsc   
2384 FA80 5B                    tcd   
2385 FA81 20 02 FB              jsr   Dec2Bin
2386 FA84 68                    pla                            ;pull result
2387 FA85 85 17                 sta   <BinVal
2388 FA87 68                    pla                            ;did result overflow ?
2389 FA88 D0 24                 bne   OverErr                  ;yes
2390 FA8A A5 0F                 lda   <Signed                  ;is value signed?
2391 FA8C F0 0F                 beq   OK                       ;no - so skip next part
2392 FA8E A5 17                 lda   <BinVal
2393 FA90 C9 00 80              cmp   #$8000                   ;check for maximum negative number
2394 FA93 D0 05                 bne   Cont
2395 FA95 C0 00 00              cpy   #0                       ;was the sign negative ?
2396 FA98 D0 03                 bne   OK                       ;yes
2397 FA9A 0A           Cont     asl   a                        ;is hi bit set?
2398 FA9B B0 11                 bcs   OverErr                  ;yes - so overflow
2399 FA9D FA           OK       plx                            ;pull error flag
2400 FA9E D0 12                 bne   RetErr
2401 FAA0 98                    tya                            ;sign flag
2402 FAA1 F0 08                 beq   Done
2403 FAA3 38                    sec                            ;sign was negative so change
2404 FAA4 A9 00 00              lda   #0                       ;result to a negative value
2405 FAA7 E5 17                 sbc   <BinVal
2406 FAA9 85 17                 sta   <BinVal
2407 FAAB 4C 3A FC     Done     jmp   EndCall8
2408 FAAE
2409 FAAE A2 03 0B     OverErr  ldx   #Overflow
2410 FAB1 68                    pla                            ;error flag
2411 FAB2 4C 3D FC     RetErr   jmp   ErrOut8
2412 FAB5                       ENDP 
2413 FAB5
2414 FAB5
2415 FAB5              ****************************************************************
2416 FAB5              *
2417 FAB5              * Dec2Long
2418 FAB5              *
2419 FAB5              * Takes an ASCII string representing a decimal value and
2420 FAB5              * produces a 4-byte signed or unsigned integer.
2421 FAB5              *
2422 FAB5              ****************************************************************
2423 FAB5
2424 FAB5                       EXPORT Dec2Long 
2425 FAB5              Dec2Long PROC 
2426 FAB5
2427 FAB5              Signed   equ   15
2428 FAB5              BinVal   equ   23
2429 FAB5
2430 FAB5 0B                    phd   
2431 FAB6 F4 00 00              PushWord #0                    ;temp space
2432 FAB9 F4 00 00              PushWord #0 
2433 FABC F4 00 00              PushWord #0 
2434 FABF 3B                    tsc   
2435 FAC0 5B                    tcd   
2436 FAC1 20 02 FB              jsr   Dec2Bin
2437 FAC4 68                    pla                            ;pull result
2438 FAC5 85 17                 sta   <BinVal
2439 FAC7 68                    pla   
2440 FAC8 85 19                 sta   <BinVal+2
2441 FACA A5 0F                 lda   <Signed                  ;is value signed?
2442 FACC F0 15                 beq   OK                       ;no - so skip next part
2443 FACE A5 19                 lda   <BinVal+2
2444 FAD0 C9 00 80              cmp   #$8000                   ;check for maximum negative number
2445 FAD3 D0 09                 bne   Cont
2446 FAD5 A5 17                 lda   <BinVal
2447 FAD7 D0 05                 bne   Cont
2448 FAD9 C0 00 00              cpy   #0                       ;was the sign negative?
2449 FADC D0 05                 bne   OK                       ;yes
2450 FADE A5 19        Cont     lda   <BinVal+2
2451 FAE0 0A                    asl   a                        ;is hi bit set?
2452 FAE1 B0 18                 bcs   OverErr                  ;yes - so overflow
2453 FAE3 FA           OK       plx                            ;error flag
2454 FAE4 D0 19                 bne   RetErr
2455 FAE6 98                    tya                            ;sign flag
2456 FAE7 F0 0F                 beq   Done
2457 FAE9 38                    sec                            ;sign was negative so change result
2458 FAEA A9 00 00              lda   #0                       ;to negative value
2459 FAED E5 17                 sbc   <BinVal
2460 FAEF 85 17                 sta   <BinVal
2461 FAF1 A9 00 00              lda   #0
2462 FAF4 E5 19                 sbc   <BinVal+2
2463 FAF6 85 19                 sta   <BinVal+2
2464 FAF8 4C 3A FC     Done     jmp   EndCall8
2465 FAFB
2466 FAFB A2 03 0B     OverErr  ldx   #Overflow
2467 FAFE 68                    pla                            ;error flag
2468 FAFF 4C 3D FC     RetErr   jmp   ErrOut8
2469 FB02                       ENDP 
2470 FB02
2471 FB02
2472 FB02              ****************************************************************
2473 FB02              *
2474 FB02              * Dec2Bin
2475 FB02              *
2476 FB02              ****************************************************************
2477 FB02
2478 FB02                       EXPORT Dec2Bin 
2479 FB02              Dec2Bin  PROC 
2480 FB02
2481 FB02              TempVal  equ   1
2482 FB02              Digit    equ   5
2483 FB02              Signed   equ   15
2484 FB02              Length   equ   17
2485 FB02              StrPtr   equ   19
2486 FB02              BinVal   equ   23
2487 FB02
2488 FB02 A0 00 00              ldy   #0                       ;string index
2489 FB05 A2 00 00              ldx   #0                       ;sign flag
2490 FB08 88                    dey   
2491 FB09 C8           Blanks   iny   
2492 FB0A C4 11                 cpy   <Length
2493 FB0C 90 01                 bcc   OK
2494 FB0E 60                    rts   
2495 FB0F
2496 FB0F B7 13        OK       lda   [<StrPtr],y              ;skip leading blanks in string
2497 FB11 29 7F 00              and   #$7F                     ;mask off hi byte and hi bit of lo byte
2498 FB14 C9 20 00              cmp   #$20
2499 FB17 F0 F0                 beq   Blanks
2500 FB19
2501 FB19 E4 0F                 cpx   <Signed                  ;is value signed?
2502 FB1B F0 11                 beq   Sign                     ;no - so skip next part
2503 FB1D
2504 FB1D C9 2B 00              cmp   #$2B                     ;is first char '+' ?
2505 FB20 D0 03                 bne   CheckNeg                 ;no
2506 FB22 C8                    iny                            ;yes - so skip first char
2507 FB23 80 09                 bra   Sign
2508 FB25
2509 FB25 C9 2D 00     CheckNeg cmp   #$2D                     ;is first char '-' ?
2510 FB28 D0 04                 bne   Sign                     ;no
2511 FB2A C8                    iny                            ;yes - so skip first char
2512 FB2B A2 FF 00              ldx   #$FF                     ;flag negative sign
2513 FB2E DA           Sign     phx                            ;save sign flag
2514 FB2F A2 00 00              ldx   #0                       ;overflow flag
2515 FB32
2516 FB32 C4 11        Loop     cpy   <Length                  ;done with string?
2517 FB34 B0 54                 bcs   Done                     ;yes
2518 FB36 B7 13                 lda   [<StrPtr],y              ;get char
2519 FB38 29 7F 00              and   #$7F                     ;mask off hi byte and hi bit of lo byte
2520 FB3B C9 30 00              cmp   #$30                     ;is char < '0' ?
2521 FB3E 90 56                 bcc   CharErr                  ;yes
2522 FB40 C9 3A 00              cmp   #$3A                     ;is char > '9' ?
2523 FB43 B0 51                 bcs   CharErr                  ;yes
2524 FB45 38                    sec   
2525 FB46 E9 30 00              sbc   #$30                     ;convert char to digit
2526 FB49 85 05                 sta   <Digit                   ;save digit
2527 FB4B
2528 FB4B 06 01                 asl   <TempVal                 ;mult val by 2
2529 FB4D 26 03                 rol   <TempVal+2
2530 FB4F 90 01                 bcc   Cont
2531 FB51 E8                    inx                            ;set flag if overflow
2532 FB52 A5 03        Cont     lda   <TempVal+2
2533 FB54 85 17                 sta   <BinVal                  ;save hi word in BinVal
2534 FB56 A5 01                 lda   <TempVal                 ;save lo word in A
2535 FB58 06 01                 asl   <TempVal
2536 FB5A 26 03                 rol   <TempVal+2
2537 FB5C 90 01                 bcc   Cont0
2538 FB5E E8                    inx                            ;set flag if overflow
2539 FB5F 06 01        Cont0    asl   <TempVal
2540 FB61 26 03                 rol   <TempVal+2               ;mult val by 8
2541 FB63 90 02                 bcc   Cont1
2542 FB65 E8                    inx                            ;set flag if overflow
2543 FB66 18                    clc   
2544 FB67 65 01        Cont1    adc   <TempVal                 ;sum with val times 2
2545 FB69 85 01                 sta   <TempVal                 ;to get val times 10
2546 FB6B A5 17                 lda   <BinVal
2547 FB6D 65 03                 adc   <TempVal+2
2548 FB6F 85 03                 sta   <TempVal+2
2549 FB71 90 02                 bcc   Cont2
2550 FB73 E8                    inx                            ;set overflow flag
2551 FB74 18                    clc   
2552 FB75 A5 01        Cont2    lda   <TempVal
2553 FB77 65 05                 adc   <Digit                   ;add digit to val
2554 FB79 85 01                 sta   <TempVal
2555 FB7B 90 0A                 bcc   Cont3
2556 FB7D A5 03                 lda   <TempVal+2
2557 FB7F 69 00 00              adc   #0
2558 FB82 85 03                 sta   <TempVal+2
2559 FB84 90 01                 bcc   Cont3
2560 FB86 E8                    inx                            ;set overflow flag
2561 FB87 C8           Cont3    iny   
2562 FB88 80 A8                 bra   Loop
2563 FB8A
2564 FB8A E0 00 00     Done     cpx   #0                       ;did overflow occur?
2565 FB8D F0 03                 beq   Return                   ;no
2566 FB8F A2 03 0B              ldx   #Overflow                ;yes
2567 FB92 86 05        Return   stx   <Digit                   ;save error flag
2568 FB94 7A                    ply                            ;sign flag
2569 FB95 60           DoRet    rts   
2570 FB96
2571 FB96 A2 02 0B     CharErr  ldx   #BadChar
2572 FB99 4C 92 FB              jmp   Return
2573 FB9C
2574 FB9C                       ENDP 
2575 FB9C              ;                copy intmath/hexit
2576 FB9C
2577 FB9C              ****************************************************************
2578 FB9C              *
2579 FB9C              * HexIt      (value : integer) : LongInt
2580 FB9C              *
2581 FB9C              * The longint that is returned is made up of four
2582 FB9C              * bytes that are the hex representation of the word.
2583 FB9C              *
2584 FB9C              * Calling Convention:
2585 FB9C              *
2586 FB9C              *              PushLong #0    ; make room on stack
2587 FB9C              *              PushWord Whatever
2588 FB9C              *              _HexIt
2589 FB9C              *              PopLong Whereever
2590 FB9C              *
2591 FB9C              ****************************************************************
2592 FB9C                       EXPORT HexIt 
2593 FB9C              HexIt    PROC 
2594 FB9C
2595 FB9C              RTL1     equ   1
2596 FB9C              RTL2     equ   RTL1+3
2597 FB9C              Value    equ   RTL2+3
2598 FB9C              Result   equ   Value+2
2599 FB9C
2600 FB9C E2 30                 sep   #%00110000               ; 8 bit mode
2601 FB9E                       longa off
2602 FB9E                       longi off
2603 FB9E A3 07                 lda   Value,s                  ; get the low byte
2604 FBA0 29 F0                 and   #$F0                     ; do the high nibble of low byte
2605 FBA2 4A                    lsr   a
2606 FBA3 4A                    lsr   a
2607 FBA4 4A                    lsr   a
2608 FBA5 4A                    lsr   a
2609 FBA6 20 CF FB              jsr   Nib2Ascii
2610 FBA9 83 0B                 sta   Result+2,s
2611 FBAB
2612 FBAB A3 07                 lda   Value,s                  ; get the low byte back
2613 FBAD 29 0F                 and   #$0F                     ; do the low nibble of the low byte
2614 FBAF 20 CF FB              jsr   Nib2Ascii
2615 FBB2 83 0C                 sta   Result+3,s
2616 FBB4
2617 FBB4 A3 08                 lda   Value+1,s                ; get the high byte
2618 FBB6 29 F0                 and   #$F0                     ; do the high nibble
2619 FBB8 4A                    lsr   a
2620 FBB9 4A                    lsr   a
2621 FBBA 4A                    lsr   a
2622 FBBB 4A                    lsr   a
2623 FBBC 20 CF FB              jsr   Nib2Ascii
2624 FBBF 83 09                 sta   Result,s
2625 FBC1
2626 FBC1 A3 08                 lda   Value+1,s
2627 FBC3 29 0F                 and   #$0F
2628 FBC5 20 CF FB              jsr   Nib2Ascii
2629 FBC8 83 0A                 sta   Result+1,s
2630 FBCA
2631 FBCA C2 30                 rep   #%00110000
2632 FBCC                       longa on
2633 FBCC                       longi on
2634 FBCC
2635 FBCC 4C F7 FB              jmp   oEndCall2
2636 FBCF
2637 FBCF
2638 FBCF              Nib2Ascii                               ; 
2639 FBCF                       longa off
2640 FBCF                       longi off
2641 FBCF
2642 FBCF C9 0A                 cmp   #10
2643 FBD1 90 03                 bcc   Less10
2644 FBD3
2645 FBD3 18                    clc   
2646 FBD4 69 07                 adc   #7
2647 FBD6
2648 FBD6 69 30        Less10   adc   #$30                     ; ascii 0
2649 FBD8 60                    rts   
2650 FBD9
2651 FBD9                       longa on
2652 FBD9                       longi on
2653 FBD9
2654 FBD9                       ENDP 
2655 FBD9
2656 FBD9
2657 FBD9                       END   
